/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentBreakpoint;
import jadex.micro.annotation.Breakpoints;
import jadex.micro.annotation.Description;
import java.util.Arrays;
import java.util.HashSet;

@Description(value="A simple agent showing how to use breakpoints in the micro kernel.")
@Breakpoints(value={"2", "5", "odd", "even", "every tenth"})
@Agent
public class CountingAgent {
    protected int cnt;
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        this.cnt = 1;
        IComponentStep<Void> step = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                final 1 step = this;
                System.out.println("Step: " + CountingAgent.this.cnt);
                ++CountingAgent.this.cnt;
                ((IExecutionFeature)CountingAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(10L, (IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ((IExecutionFeature)CountingAgent.this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep(step);
                        return IFuture.DONE;
                    }
                });
                return IFuture.DONE;
            }

            public String toString() {
                return "counter.inc(" + CountingAgent.this.cnt + ")";
            }
        };
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)step);
        return new Future();
    }

    @AgentBreakpoint
    public boolean isAtBreakpoint(String[] breakpoints) {
        boolean isatbreakpoint = false;
        HashSet<String> bps = new HashSet<String>(Arrays.asList(breakpoints));
        isatbreakpoint = isatbreakpoint || bps.contains(Integer.toString(this.cnt));
        isatbreakpoint = isatbreakpoint || this.cnt % 2 != 0 && bps.contains("odd");
        isatbreakpoint = isatbreakpoint || this.cnt % 2 == 0 && bps.contains("even");
        isatbreakpoint = isatbreakpoint || this.cnt % 10 == 0 && bps.contains("every tenth");
        return isatbreakpoint;
    }
}

