/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentBreakpoint;
import jadex.micro.annotation.Breakpoints;
import jadex.micro.annotation.Description;
import java.util.Arrays;
import java.util.HashSet;

@Description(value="A simple agent showing how to use breakpoints in the micro kernel.")
@Breakpoints(value={"hop", "step", "jump"})
@Agent
public class PojoBreakpointAgent {
    @Agent
    protected IInternalAccess agent;
    protected String step;

    @AgentBody
    public IFuture<Void> executeBody() {
        this.step = "hop";
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                System.out.println("Current step: " + PojoBreakpointAgent.this.step);
                PojoBreakpointAgent.this.step = "step";
                ((IExecutionFeature)PojoBreakpointAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        System.out.println("Current step: " + PojoBreakpointAgent.this.step);
                        PojoBreakpointAgent.this.step = "jump";
                        ((IExecutionFeature)PojoBreakpointAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)new IComponentStep<Void>(){

                            public IFuture<Void> execute(IInternalAccess ia) {
                                System.out.println("Current step: " + PojoBreakpointAgent.this.step);
                                PojoBreakpointAgent.this.agent.killComponent();
                                return IFuture.DONE;
                            }
                        });
                        return IFuture.DONE;
                    }
                });
                return IFuture.DONE;
            }
        });
        return new Future();
    }

    @AgentBreakpoint
    public boolean isAtBreakpoint(String[] breakpoints) {
        return new HashSet<String>(Arrays.asList(breakpoints)).contains(this.step);
    }
}

