/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic;

import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;

@Description(value="This agent starts a subagent and fetches its result.")
@Results(value={@Result(name="result", clazz=String.class, defaultvalue="0", description="Result value.")})
@Agent
public class ResultAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        if (Math.random() < 0.3) {
            ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("result", "last: " + this.agent.getComponentIdentifier() + ": " + Math.random());
            ret.setResult(null);
        } else {
            ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("result", "not last: " + this.agent.getComponentIdentifier() + ": " + Math.random());
            SServiceProvider.getService((IInternalAccess)this.agent, IComponentManagementService.class, (String)"platform").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener(){

                public void resultAvailable(Object result) {
                    IComponentManagementService cms = (IComponentManagementService)result;
                    cms.createComponent(null, ResultAgent.this.getClass().getName() + ".class", new CreationInfo(ResultAgent.this.agent.getComponentIdentifier()), ((IExecutionFeature)ResultAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                        public void resultAvailable(Object result) {
                            System.out.println(ResultAgent.this.agent.getComponentIdentifier() + " got result: " + result);
                            ret.setResult(null);
                        }

                        public void exceptionOccurred(Exception exception) {
                            System.out.println("exception occurred: " + exception);
                            ret.setResult(null);
                        }
                    })).addResultListener(new IResultListener(){

                        public void resultAvailable(Object result) {
                        }

                        public void exceptionOccurred(Exception exception) {
                            System.out.println("Could not create agent: " + exception);
                            ret.setResult(null);
                        }
                    });
                }
            }));
        }
        return ret;
    }
}

