/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic.compositeservice;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.semiautomatic.compositeservice.IAddService;
import jadex.micro.testcases.semiautomatic.compositeservice.ISubService;

@Description(value="This agent is an empty minimal calculator.")
@RequiredServices(value={@RequiredService(name="addservice", type=IAddService.class, binding=@Binding(scope="platform")), @RequiredService(name="subservice", type=ISubService.class, binding=@Binding(scope="platform"))})
@Agent
public class CompositeCalculatorAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        this.add(1.0, 1.0).addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                System.out.println("Result is: " + result);
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("Service invocation failed: " + exception);
            }
        });
        return new Future();
    }

    protected IFuture add(final double a, final double b) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("addservice").addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                IAddService add = (IAddService)result;
                add.add(a, b).addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("Could not get required add service: " + exception);
            }
        });
        return ret;
    }
}

