/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic.nfpropvis;

import jadex.bridge.ComponentResultListener;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.search.ComposedEvaluator;
import jadex.bridge.nonfunctional.search.IServiceEvaluator;
import jadex.bridge.sensor.service.AverageEvaluator;
import jadex.bridge.sensor.service.WaitqueueEvaluator;
import jadex.bridge.service.IService;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.commons.MethodInfo;
import jadex.commons.Tuple2;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentKilled;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.semiautomatic.nfpropvis.ICryptoService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;

@RequiredServices(value={@RequiredService(name="aser", type=ICryptoService.class, multiple=true, binding=@Binding(scope="platform", dynamic=true))})
@Agent
@Service
@Configurations(value={@Configuration(name="default"), @Configuration(name="with gui")})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;
    protected ComposedEvaluator<ICryptoService> ranker;
    protected JFrame frame;
    protected JFreeChart chart;
    protected Map<Comparable, Integer> seriesmap = new HashMap<Comparable, Integer>();

    @AgentBody
    public void body() throws Exception {
        this.ranker = new ComposedEvaluator();
        AverageEvaluator eva = new AverageEvaluator((IServiceEvaluator)new WaitqueueEvaluator(this.agent.getExternalAccess(), new MethodInfo(ICryptoService.class.getMethod("encrypt", String.class))));
        this.ranker.addEvaluator((IServiceEvaluator)eva);
        this.invoke();
    }

    @AgentKilled
    public void cleanup() {
        if (this.frame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserAgent.this.frame.dispose();
                }
            });
        }
    }

    public void invoke() {
        final boolean wgui = this.agent.getConfiguration().equals("with gui");
        IComponentStep<Void> step = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                UserAgent.this.invoke();
                return IFuture.DONE;
            }
        };
        ITerminableIntermediateFuture sfut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("aser");
        SServiceProvider.rankServicesWithScores((ITerminableIntermediateFuture)sfut, this.ranker, null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Collection<Tuple2<ICryptoService, Double>>>((IComponentStep)step){
            final /* synthetic */ IComponentStep val$step;
            {
                this.val$step = iComponentStep;
            }

            public void resultAvailable(Collection<Tuple2<ICryptoService, Double>> res) {
                if (wgui) {
                    UserAgent.this.addData(res);
                }
                ICryptoService aser = (ICryptoService)res.iterator().next().getFirstEntity();
                aser.encrypt("bla").addResultListener((IResultListener)new ComponentResultListener((IResultListener)new IResultListener<String>(){

                    public void resultAvailable(String result) {
                        UserAgent.this.invoke();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(2000L, val$step);
                    }
                }, UserAgent.this.agent.getExternalAccess()));
            }

            public void exceptionOccurred(Exception exception) {
                ((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(2000L, this.val$step);
            }
        }));
    }

    public void addData(Collection<Tuple2<ICryptoService, Double>> res) {
        for (Tuple2<ICryptoService, Double> tup : res) {
            ICryptoService ser = (ICryptoService)tup.getFirstEntity();
            Double val = (Double)tup.getSecondEntity();
            this.addValue((Comparable<?>)((Object)((IService)ser).getServiceIdentifier().toString()), System.currentTimeMillis(), val);
        }
    }

    public JPanel getChartPanel() {
        ChartPanel panel = new ChartPanel(this.getChart(), false, false, false, false, false);
        panel.setFillZoomRectangle(true);
        return panel;
    }

    public JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = this.createChart();
        }
        return this.chart;
    }

    protected JFreeChart createChart() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Service Quality", (String)"ms", (String)"score", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)true);
        chart.setNotify(true);
        ChartPanel panel = new ChartPanel(chart);
        panel.setFillZoomRectangle(true);
        this.frame = new JFrame();
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)panel, "Center");
        this.frame.setContentPane((Container)panel);
        this.frame.pack();
        this.frame.setVisible(true);
        return chart;
    }

    protected void addValue(Comparable<?> seriesname, Object valx, Object valy) {
        int seriesnum = 0;
        TimeSeriesCollection dataset = (TimeSeriesCollection)((XYPlot)this.getChart().getPlot()).getDataset();
        int sercnt = dataset.getSeriesCount();
        Integer sernum = this.seriesmap.get(seriesname);
        seriesnum = sernum != null ? sernum : sercnt;
        Class<Millisecond> time = Millisecond.class;
        for (int j = sercnt; j <= seriesnum; ++j) {
            TimeSeries series;
            Integer maxitemcnt = 10000;
            if (seriesname != null) {
                series = new TimeSeries(seriesname, time);
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(seriesname, j);
            } else {
                series = new TimeSeries((Comparable)Integer.valueOf(j), time);
                if (maxitemcnt != null) {
                    series.setMaximumItemCount(maxitemcnt.intValue());
                }
                this.seriesmap.put(Integer.valueOf(j), j);
            }
            dataset.addSeries(series);
        }
        TimeSeries ser = dataset.getSeries(seriesnum);
        Millisecond t = null;
        if (Millisecond.class.equals(time) || time == null) {
            t = new Millisecond(new Date(((Number)valx).longValue()));
        } else if (Second.class.equals(time)) {
            t = new Second(new Date(((Number)valx).longValue()));
        } else if (Hour.class.equals(time)) {
            t = new Hour(new Date(((Number)valx).longValue()));
        } else if (Day.class.equals(time)) {
            t = new Day(new Date(((Number)valx).longValue()));
        } else if (Week.class.equals(time)) {
            t = new Week(new Date(((Number)valx).longValue()));
        } else if (Month.class.equals(time)) {
            t = new Month(new Date(((Number)valx).longValue()));
        } else if (Quarter.class.equals(time)) {
            t = new Quarter(new Date(((Number)valx).longValue()));
        } else if (Year.class.equals(time)) {
            t = new Year(new Date(((Number)valx).longValue()));
        }
        ser.addOrUpdate((RegularTimePeriod)t, ((Number)valy).doubleValue());
    }
}

