/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.semiautomatic.remoteservice;

import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.remote.IRemoteServiceManagementService;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.testcases.semiautomatic.remoteservice.IMathService;

@Agent
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final CounterResultListener lis = new CounterResultListener(2, new IResultListener(){

            public void resultAvailable(Object result) {
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
                ret.setResult(null);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                ((IRequiredServicesFeature)UserAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                        ComponentIdentifier platid = new ComponentIdentifier("remote", new String[]{"tcp-mtp://127.0.0.1:11000", "nio-mtp://127.0.0.1:11001"});
                        rms.getServiceProxy(UserAgent.this.agent.getComponentIdentifier(), (IComponentIdentifier)platid, IMathService.class, "platform", null).addResultListener(((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                            public void resultAvailable(Object result) {
                                IMathService service = (IMathService)result;
                                UserAgent.this.invokeAddService("IMathService searched via rms.", service).addResultListener((IResultListener)lis);
                            }

                            public void exceptionOccurred(Exception exception) {
                                lis.resultAvailable(null);
                            }
                        }));
                    }

                    public void exceptionOccurred(Exception exception) {
                        lis.resultAvailable(null);
                    }
                });
            }

            public void exceptionOccurred(Exception exception) {
                lis.resultAvailable(null);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IMathService.class, "global").addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                IMathService service = (IMathService)result;
                UserAgent.this.invokeAddService("IMathService searched via platform proxy.", service).addResultListener((IResultListener)lis);
            }

            public void exceptionOccurred(Exception exception) {
                lis.resultAvailable(null);
            }
        });
        return ret;
    }

    protected IFuture invokeAddService(String info, IMathService service) {
        Future ret = new Future();
        if (service == null) {
            System.out.println("No remote add service found: " + info);
            ret.setResult(null);
        } else {
            final CounterResultListener lis = new CounterResultListener(2, (IResultListener)new DelegationResultListener(ret));
            System.out.println("Found service: " + info);
            service.addNB(1, 2).addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    System.out.println("Invoked addNB: " + result);
                    lis.resultAvailable(null);
                }

                public void exceptionOccurred(Exception exception) {
                    lis.resultAvailable(null);
                }
            });
            int res = service.addB(1, 2);
            System.out.println("Invoked addB: " + res);
            System.out.println("Calling constant (non-blocking) getPi method.");
            double pi = service.getPi();
            System.out.println("Invoked getPi: " + pi);
            System.out.println("Calling void (non-blocking) printMessage method.");
            service.printMessage("math service");
            System.out.println("Invoked printMessage");
            System.out.println("Calling (non-blocking) exception throwing divZero method.");
            service.divZero().addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    System.out.println("Invoked divZero without exception");
                    lis.resultAvailable(null);
                }

                public void exceptionOccurred(Exception exception) {
                    System.out.println("Invoked divZero, expected exception occurred: " + exception);
                    lis.resultAvailable(null);
                }
            });
        }
        return ret;
    }
}

