/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.servicescope;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.Boolean3;
import jadex.commons.future.ITuple2Future;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.servicescope.IExampleService;
import jadex.micro.testcases.servicescope.ProviderAgent;

@Agent(keepalive=Boolean3.FALSE)
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform")), @RequiredService(name="exaser", type=IExampleService.class, binding=@Binding(scope="platform"))})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AgentBody
    public void body() {
        IExampleService ser;
        ITuple2Future fut22;
        Testcase tc = new Testcase();
        tc.setTestCount(2);
        IComponentManagementService cms = (IComponentManagementService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms").get();
        IComponentIdentifier cid = null;
        TestReport tr = new TestReport("#1", "Test if service with scope application can be found when provider is child of user");
        try {
            fut22 = cms.createComponent(ProviderAgent.class.getName() + ".class", new CreationInfo(this.agent.getComponentIdentifier()));
            cid = (IComponentIdentifier)fut22.getFirstResult();
            ser = (IExampleService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("exaser").get();
            tr.setSucceeded(true);
            try {
                if (cid != null) {
                    cms.destroyComponent(cid).get();
                }
            }
            catch (Exception fut22) {}
        }
        catch (Exception e) {
            tr.setFailed("Problem: could not find service: " + e);
        }
        finally {
            try {
                if (cid != null) {
                    cms.destroyComponent(cid).get();
                }
            }
            catch (Exception e) {}
        }
        tc.addReport(tr);
        cid = null;
        tr = new TestReport("#1", "Test if service with scope application can be found when provider is sibling");
        try {
            fut22 = cms.createComponent(ProviderAgent.class.getName() + ".class", new CreationInfo(this.agent.getModel().getResourceIdentifier()));
            cid = (IComponentIdentifier)fut22.getFirstResult();
            ser = (IExampleService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("exaser").get();
            System.out.println("Problem: could find hidden service: " + (String)ser.getInfo().get());
            tr.setFailed("Problem: could find hidden service");
        }
        catch (Exception e) {
            System.out.println("Correct: could not find service");
            tr.setSucceeded(true);
        }
        finally {
            try {
                if (cid != null) {
                    cms.destroyComponent(cid).get();
                }
            }
            catch (Exception exception) {}
        }
        tc.addReport(tr);
        ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
    }
}

