/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.servicevalue;

import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.SFuture;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.testcases.servicevalue.INewsService;
import java.util.ArrayList;
import java.util.List;

@Agent(autoprovide=true)
public class NewsProviderAgent
implements INewsService {
    @Agent
    protected IInternalAccess agent;
    protected List<SubscriptionIntermediateFuture<String>> subscriptions = new ArrayList<SubscriptionIntermediateFuture<String>>();

    @AgentBody
    public void body() {
        for (int i = 0; i < 100; ++i) {
            ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(2000L).get();
            for (SubscriptionIntermediateFuture<String> sub : this.subscriptions) {
                if (sub.addIntermediateResultIfUndone((Object)("News " + i))) continue;
                this.subscriptions.remove(sub);
            }
        }
    }

    @Override
    public ISubscriptionIntermediateFuture<String> subscribeToNews() {
        final SubscriptionIntermediateFuture ret = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IExternalAccess)this.agent.getExternalAccess());
        ret.setTerminationCommand(new ITerminationCommand(){

            public void terminated(Exception reason) {
                NewsProviderAgent.this.subscriptions.remove(ret);
            }

            public boolean checkTermination(Exception reason) {
                return true;
            }
        });
        this.subscriptions.add((SubscriptionIntermediateFuture<String>)ret);
        return ret;
    }
}

