/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.stream;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInputConnection;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.message.IMessageService;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.stream.Receiver2Agent;
import jadex.micro.testcases.stream.StreamProviderAgent;
import jadex.micro.testcases.stream.TestReportListener;
import java.util.Collection;
import java.util.Map;

@Agent
public class Initiator2Agent
extends TestAgent {
    protected IInputConnection icon;

    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                Initiator2Agent.this.testRemote(2).addResultListener(((IExecutionFeature)Initiator2Agent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(int testno) {
        return this.performTest(this.agent.getComponentIdentifier().getRoot(), testno);
    }

    protected IFuture<TestReport> testRemote(final int testno) {
        final Future ret = new Future();
        this.createPlatform(null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                    public void customResultAvailable(ITransportComponentIdentifier result) {
                        Initiator2Agent.this.performTest((IComponentIdentifier)result, testno).addResultListener(((IExecutionFeature)Initiator2Agent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }
                });
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if streams work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        final Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent("jadex/micro/testcases/stream/Receiver2Agent.class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(final IComponentIdentifier cid) {
                IFuture msfut = ((IRequiredServicesFeature)Initiator2Agent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("msgservice");
                msfut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IMessageService, TestReport>(ret){

                    public void customResultAvailable(IMessageService ms) {
                        ms.createInputConnection(Initiator2Agent.this.agent.getComponentIdentifier(), cid, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IInputConnection, TestReport>(ret){

                            public void customResultAvailable(IInputConnection icon) {
                                Initiator2Agent.this.receiveBehavior(testno, icon, (IFuture<Collection<Tuple2<String, Object>>>)resfut).addResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                                    public void customResultAvailable(final TestReport tr) {
                                        Initiator2Agent.this.destroyComponent(cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<Map<String, Object>, TestReport>(ret){

                                            public void customResultAvailable(Map<String, Object> result) {
                                                ret.setResult((Object)tr);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        return res;
    }

    protected IFuture<TestReport> receiveBehavior(int testno, IInputConnection con, IFuture<Collection<Tuple2<String, Object>>> resfut) {
        Future ret = new Future();
        TestReport tr = new TestReport("" + testno, "Test if file is transferred correctly.");
        StreamProviderAgent.read(con).addResultListener((IResultListener)new TestReportListener(tr, (Future<TestReport>)ret, Receiver2Agent.getNumberOfBytes()));
        return ret;
    }
}

