/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.stream;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IOutputConnection;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.message.IMessageService;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.testcases.TestAgent;
import java.io.InputStream;
import java.util.Collection;

@Agent
@Arguments(replace=false, value={@Argument(name="filename", clazz=String.class, defaultvalue="\"jadex/micro/testcases/stream/test.jpg\"")})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                if (SReflect.isAndroid()) {
                    tc.setTestCount(1);
                    ret.setResult(null);
                } else {
                    InitiatorAgent.this.testRemote(2).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                        public void customResultAvailable(TestReport result) {
                            tc.addReport(result);
                            ret.setResult(null);
                        }
                    }));
                }
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(int testno) {
        return this.performTest(this.agent.getComponentIdentifier().getRoot(), testno);
    }

    protected IFuture<TestReport> testRemote(final int testno) {
        final Future ret = new Future();
        this.createPlatform(null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                    public void customResultAvailable(ITransportComponentIdentifier result) {
                        InitiatorAgent.this.performTest((IComponentIdentifier)result, testno).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }
                });
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if streams work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        final Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent("jadex/micro/testcases/stream/ReceiverAgent.class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(final IComponentIdentifier cid) {
                IFuture msfut = ((IRequiredServicesFeature)InitiatorAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("msgservice");
                msfut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IMessageService, TestReport>(ret){

                    public void customResultAvailable(IMessageService ms) {
                        ms.createOutputConnection(InitiatorAgent.this.agent.getComponentIdentifier(), cid, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IOutputConnection, TestReport>(ret){

                            public void customResultAvailable(IOutputConnection ocon) {
                                InitiatorAgent.this.sendBehavior(testno, ocon, (IFuture<Collection<Tuple2<String, Object>>>)resfut).addResultListener((IResultListener)new DelegationResultListener(ret));
                            }
                        });
                    }
                });
            }
        });
        return res;
    }

    protected IFuture<TestReport> sendBehavior(int testno, final IOutputConnection con, IFuture<Collection<Tuple2<String, Object>>> resfut) {
        final long start = System.currentTimeMillis();
        final long[] filesize = new long[1];
        final Future ret = new Future();
        try {
            final InputStream is = SUtil.getResource((String)((String)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("filename")), (ClassLoader)this.agent.getClassLoader());
            final TestReport tr = new TestReport("" + testno, "Test if file is transferred correctly.");
            resfut.addResultListener((IResultListener)new IResultListener<Collection<Tuple2<String, Object>>>(){

                public void resultAvailable(Collection<Tuple2<String, Object>> results) {
                    Long fs = (Long)jadex.bridge.modelinfo.Argument.getResult(results, (String)"filesize");
                    if (fs != null) {
                        if (fs == filesize[0]) {
                            long end = System.currentTimeMillis();
                            System.out.println("Needed " + (double)(end - start) / 1000.0 + " seconds for " + filesize[0] / 1024L + " kbytes.");
                            tr.setSucceeded(true);
                        } else {
                            tr.setFailed("Wrong file size [expected, received]: " + filesize[0] + " " + fs);
                        }
                    } else {
                        tr.setFailed("No target file size reported.");
                    }
                    ret.setResult((Object)tr);
                }

                public void exceptionOccurred(Exception exception) {
                    tr.setFailed("Receiver agent had exception: " + exception);
                    ret.setResult((Object)tr);
                }
            });
            IComponentStep<Void> step = new IComponentStep<Void>(){

                public IFuture<Void> execute(IInternalAccess ia) {
                    try {
                        final 6 self = this;
                        int size = Math.min(200000, is.available());
                        filesize[0] = filesize[0] + (long)size;
                        byte[] buf = new byte[size];
                        for (int read = 0; read != buf.length; read += is.read(buf, read, buf.length - read)) {
                        }
                        con.write(buf);
                        if (is.available() > 0) {
                            con.waitForReady().addResultListener((IResultListener)new IResultListener<Integer>(){

                                public void resultAvailable(Integer result) {
                                    ((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep(self);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    exception.printStackTrace();
                                    con.close();
                                }
                            });
                        } else {
                            con.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ret.setException(e);
                    }
                    return IFuture.DONE;
                }
            };
            ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)step);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.setException(e);
        }
        return ret;
    }
}

