/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.stream;

import jadex.bridge.IConnection;
import jadex.bridge.IInputConnection;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.types.context.IContextService;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.AgentStreamArrived;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;

@Arguments(value={@Argument(name="filename", clazz=String.class, defaultvalue="\"copy.copy\"")})
@Results(value={@Result(name="filesize", clazz=long.class)})
@RequiredServices(value={@RequiredService(name="contextService", type=IContextService.class, binding=@Binding(scope="platform"))})
@Agent
public class ReceiverAgent {
    @Agent
    protected IInternalAccess agent;
    @AgentArgument
    protected String filename;
    @AgentService
    protected IContextService contextService;

    @AgentStreamArrived
    public void streamArrvied(IConnection con) {
        this.receiveBehavior((IInputConnection)con);
    }

    public void receiveBehavior(IInputConnection con) {
        try {
            final long[] cnt = new long[1];
            File f = (File)this.contextService.getFile(this.filename).get();
            final FileOutputStream fos = new FileOutputStream(f);
            ISubscriptionIntermediateFuture fut = con.aread();
            fut.addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<byte[]>(){

                public void resultAvailable(Collection<byte[]> result) {
                }

                public void intermediateResultAvailable(byte[] result) {
                    cnt[0] = cnt[0] + (long)result.length;
                    try {
                        fos.write(result);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void finished() {
                    try {
                        fos.close();
                        ((IArgumentsResultsFeature)ReceiverAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("filesize", cnt[0]);
                        ReceiverAgent.this.agent.killComponent();
                    }
                    catch (Exception e) {
                        ReceiverAgent.this.agent.killComponent();
                    }
                }

                public void exceptionOccurred(Exception exception) {
                    ReceiverAgent.this.agent.killComponent();
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.agent.killComponent();
        }
    }
}

