/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.stream;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInputConnection;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IOutputConnection;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.SecureTransmission;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.types.remote.ServiceInputConnection;
import jadex.bridge.service.types.remote.ServiceOutputConnection;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.stream.IStreamService;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@ProvidedServices(value={@ProvidedService(type=IStreamService.class, implementation=@Implementation(expression="$pojoagent"))})
@Results(value={@Result(name="testcases", clazz=List.class)})
@Service(value=IStreamService.class)
@Agent
public class StreamProviderAgent
implements IStreamService {
    @Agent
    protected IInternalAccess agent;

    @Override
    public IFuture<IInputConnection> getInputStream() {
        Future ret = new Future();
        ServiceOutputConnection oc = new ServiceOutputConnection();
        StreamProviderAgent.write((IOutputConnection)oc, this.agent);
        ret.setResult((Object)oc.getInputConnection());
        return ret;
    }

    @Override
    public IFuture<IOutputConnection> getOutputStream() {
        Future ret = new Future();
        ServiceInputConnection ic = new ServiceInputConnection();
        StreamProviderAgent.read((IInputConnection)ic);
        ret.setResult((Object)ic.getOutputConnection());
        return ret;
    }

    @Override
    public IFuture<Long> passInputStream(IInputConnection con) {
        return StreamProviderAgent.read(con);
    }

    @Override
    public IFuture<Long> passOutputStream(IOutputConnection con) {
        return StreamProviderAgent.write(con, this.agent);
    }

    @Override
    @SecureTransmission
    public IFuture<IInputConnection> getSecureInputStream() {
        return this.getInputStream();
    }

    @Override
    @SecureTransmission
    public IFuture<IOutputConnection> getSecureOutputStream() {
        return this.getOutputStream();
    }

    @Override
    @SecureTransmission
    public IFuture<Long> passSecureInputStream(IInputConnection con) {
        Boolean sec;
        Map props = con.getNonFunctionalProperties();
        Boolean bl = sec = props != null ? (Boolean)props.get("secure_transmission") : null;
        if (sec == null || !sec.booleanValue()) {
            return new Future((Exception)new RuntimeException("Received unsecure stream in 'passSecureInputStream'"));
        }
        return this.passInputStream(con);
    }

    @Override
    @SecureTransmission
    public IFuture<Long> passSecureOutputStream(IOutputConnection con) {
        Boolean sec;
        System.out.println("rec: " + con.getNonFunctionalProperties());
        Map props = con.getNonFunctionalProperties();
        Boolean bl = sec = props != null ? (Boolean)props.get("secure_transmission") : null;
        if (sec == null || !sec.booleanValue()) {
            return new Future((Exception)new RuntimeException("Received unsecure stream in 'passSecureOutputStream'"));
        }
        return this.passOutputStream(con);
    }

    public static IFuture<Long> read(IInputConnection con) {
        final Future ret = new Future();
        final long[] size = new long[1];
        con.aread().addResultListener((IResultListener)new IIntermediateResultListener<byte[]>(){

            public void resultAvailable(Collection<byte[]> result) {
                ret.setResult((Object)size[0]);
            }

            public void intermediateResultAvailable(byte[] result) {
                size[0] = size[0] + (long)result.length;
            }

            public void finished() {
                ret.setResult((Object)size[0]);
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public static IFuture<Long> write(final IOutputConnection con, final IInternalAccess agent) {
        final Future ret = new Future();
        final long[] size = new long[1];
        final int[] cnt = new int[]{0};
        IComponentStep<Void> step = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                con.write(new byte[]{(byte)cnt[0]});
                size[0] = size[0] + 1L;
                int n = cnt[0];
                cnt[0] = n + 1;
                if (n < 50) {
                    ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(50L, (IComponentStep)this);
                } else {
                    con.close();
                    ret.setResult((Object)size[0]);
                }
                return IFuture.DONE;
            }
        };
        ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)step);
        return ret;
    }

    public static long getWriteLength() {
        return 51L;
    }
}

