/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.subresults;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.Tuple2;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.subresults.ResultProducerAgent;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@ComponentTypes(value={@ComponentType(name="producer", clazz=ResultProducerAgent.class)})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        IComponentManagementService cms = (IComponentManagementService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms").get();
        IComponentIdentifier cid = (IComponentIdentifier)cms.createComponent("producer", new CreationInfo(this.agent.getComponentIdentifier())).getFirstResult();
        IExternalAccess ea = (IExternalAccess)cms.getExternalAccess(cid).get();
        final TestReport tr = new TestReport("#1", "Test if intermediate results are retrieved.");
        ea.subscribeToResults().addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<Tuple2<String, Object>>(){
            boolean ok = false;

            public void intermediateResultAvailable(Tuple2<String, Object> result) {
                System.out.println("received: " + result);
                if (result != null && "res".equals(result.getFirstEntity())) {
                    this.ok = true;
                }
            }

            public void finished() {
                System.out.println("fini");
                if (this.ok) {
                    tr.setSucceeded(true);
                } else {
                    tr.setFailed("No intermediate results have been retrieved.");
                }
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                UserAgent.this.agent.killComponent();
            }

            public void resultAvailable(Collection<Tuple2<String, Object>> result) {
                System.out.println("ra: " + result);
                tr.setFailed("No intermediate results have been retrieved: " + result);
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                UserAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("ex: " + exception);
                tr.setFailed("Exception occrred: " + exception);
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                UserAgent.this.agent.killComponent();
            }
        }));
    }
}

