/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.subscriptionlistener;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.CollectingIntermediateResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.CreationInfo;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.subscriptionlistener.ITestService;
import jadex.micro.testcases.subscriptionlistener.ProviderAgent;
import java.util.ArrayList;
import java.util.Collection;

@RequiredServices(value={@RequiredService(name="test", type=ITestService.class, binding=@Binding(create=true, creationinfo=@CreationInfo(type="test")))})
@ComponentTypes(value={@ComponentType(name="test", clazz=ProviderAgent.class)})
@Agent
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class ListenerAgent {
    @AgentBody
    public IFuture<Void> body(final IInternalAccess agent) {
        final Future ret = new Future();
        final ArrayList<TestReport> reports = new ArrayList<TestReport>();
        ITestService ts = (ITestService)((IRequiredServicesFeature)agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("test").get();
        ISubscriptionIntermediateFuture<String> fut = ts.test();
        TestReport tr = new TestReport("#1", "Test addition of wrong listener.");
        try {
            fut.addResultListener((IResultListener)new IResultListener<Collection<String>>(){

                public void resultAvailable(Collection<String> result) {
                }

                public void exceptionOccurred(Exception exception) {
                }
            });
            tr.setFailed("Wrong listener could be added.");
        }
        catch (IllegalArgumentException e) {
            tr.setSucceeded(true);
        }
        reports.add(tr);
        final TestReport tr2 = new TestReport("#2", "Test collecting listener.");
        fut.addResultListener((IResultListener)new CollectingIntermediateResultListener<String>(){

            public void resultAvailable(Collection<String> result) {
                tr2.setSucceeded(true);
                this.proceed();
            }

            public void exceptionOccurred(Exception exception) {
                tr2.setFailed(exception);
                this.proceed();
            }

            protected void proceed() {
                reports.add(tr2);
                ((IArgumentsResultsFeature)agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(reports.size(), reports.toArray(new TestReport[reports.size()])));
                ret.setResult(null);
            }
        });
        return ret;
    }
}

