/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.terminate;

import jadex.base.test.TestReport;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.IntermediateExceptionDelegationResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Description;
import jadex.micro.testcases.terminate.ITerminableService;
import jadex.micro.testcases.terminate.InvokerAgent;
import java.util.Collection;

@Agent
@Description(value="The intermediate invoker agent tests if intermediate futures can be terminated in local and remote cases.")
public class IntermediateInvokerAgent
extends InvokerAgent {
    @Override
    protected IFuture<TestReport> testTerminate(int testno, ITerminableService service, long delay) {
        final Future tmp = new Future();
        int max = 3;
        final ITerminableIntermediateFuture<String> fut = service.getResults(delay, max);
        fut.addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<String>(){

            public void resultAvailable(Collection<String> result) {
                tmp.setException((Exception)new RuntimeException("Termination did not occur: " + result));
            }

            public void intermediateResultAvailable(String result) {
            }

            public void finished() {
                tmp.setException((Exception)new RuntimeException("Termination did not occur"));
            }

            public void exceptionOccurred(Exception exception) {
                if (exception instanceof FutureTerminatedException) {
                    tmp.setResult(null);
                } else {
                    tmp.setException((Exception)new RuntimeException("Wrong exception occurred: " + exception));
                }
            }
        }));
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay * (long)(max - 1) + delay / 2L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                fut.terminate();
                return IFuture.DONE;
            }
        });
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Tests if intermediate future is terminated");
        tmp.addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

            public void customResultAvailable(Void result) {
                tr.setSucceeded(true);
                ret.setResult((Object)tr);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed(exception.getMessage());
                ret.setResult((Object)tr);
            }
        });
        return ret;
    }

    @Override
    protected IFuture<TestReport> testTerminateAction(int testno, ITerminableService service, long delay) {
        final Future tmp = new Future();
        final ITerminableIntermediateFuture<String> fut = service.getResults(delay, 3);
        service.terminateCalled().addResultListener((IResultListener)new IntermediateExceptionDelegationResultListener<Void, Void>(tmp){

            public void intermediateResultAvailable(Void result) {
                fut.terminate();
            }

            public void customResultAvailable(Collection<Void> result) {
                tmp.setResult(null);
            }

            public void finished() {
                tmp.setResult(null);
            }
        });
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Tests if terminating action of intermediate future is called");
        tmp.addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

            public void customResultAvailable(Void result) {
                tr.setSucceeded(true);
                ret.setResult((Object)tr);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed(exception.getMessage());
                ret.setResult((Object)tr);
            }
        });
        return ret;
    }
}

