/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.terminate;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableFuture;
import jadex.commons.future.IntermediateExceptionDelegationResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.terminate.ITerminableService;
import java.util.Collection;

@Agent
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Description(value="The invoker agent tests if futures can be terminated in local and remote cases.")
public class InvokerAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        final Testcase tc = new Testcase();
        if (SReflect.isAndroid()) {
            tc.setTestCount(2);
        } else {
            tc.setTestCount(4);
        }
        final Future ret = new Future();
        ret.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                tc.addReport(new TestReport("#0", "Unexpected exception", exception));
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }
        }));
        this.testLocal(1, 100L).addResultListener((IResultListener)new ExceptionDelegationResultListener<Collection<TestReport>, Void>(ret){

            public void customResultAvailable(Collection<TestReport> result) {
                for (TestReport rep : result) {
                    tc.addReport(rep);
                }
                if (SReflect.isAndroid()) {
                    ret.setResult(null);
                } else {
                    InvokerAgent.this.testRemote(3, 1000L).addResultListener((IResultListener)new ExceptionDelegationResultListener<Collection<TestReport>, Void>(ret){

                        public void customResultAvailable(Collection<TestReport> result) {
                            for (TestReport rep : result) {
                                tc.addReport(rep);
                            }
                            ret.setResult(null);
                        }
                    });
                }
            }
        });
    }

    protected IFuture<Collection<TestReport>> testLocal(int testno, long delay) {
        return this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, delay);
    }

    protected IFuture<Collection<TestReport>> testRemote(final int testno, final long delay) {
        final Future ret = new Future();
        try {
            String url = SUtil.getOutputDirsExpression((String)"../jadex-applications-micro");
            Starter.createPlatform((String[])new String[]{"-libpath", url, "-platformname", this.agent.getComponentIdentifier().getPlatformPrefix() + "_*", "-saveonexit", "false", "-welcome", "false", "-autoshutdown", "false", "-awareness", "false", "-gui", "false", "-simulation", "false", "-printpass", "false"}).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Collection<TestReport>>(ret){

                public void customResultAvailable(final IExternalAccess platform) {
                    ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, Collection<TestReport>>(ret){

                        public void customResultAvailable(ITransportComponentIdentifier result) {
                            InvokerAgent.this.performTest((IComponentIdentifier)result, testno, delay).addResultListener((IResultListener)new DelegationResultListener<Collection<TestReport>>(ret){

                                public void customResultAvailable(Collection<TestReport> result) {
                                    platform.killComponent();
                                    ret.setResult(result);
                                }
                            });
                        }
                    });
                }
            }));
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    protected IIntermediateFuture<TestReport> performTest(final IComponentIdentifier root, final int testno, final long delay) {
        final IntermediateFuture ret = new IntermediateFuture();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, root).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Collection<TestReport>>((Future)ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                ResourceIdentifier rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, InvokerAgent.this.agent.getModel().getResourceIdentifier().getLocalIdentifier().getUri()), null);
                cms.createComponent(null, "jadex/micro/testcases/terminate/TerminableProviderAgent.class", new CreationInfo((IResourceIdentifier)rid), null).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Collection<TestReport>>((Future)ret){

                    public void customResultAvailable(final IComponentIdentifier cid) {
                        ret.addResultListener((IResultListener)new IResultListener<Collection<TestReport>>(){

                            public void resultAvailable(Collection<TestReport> result) {
                                cms.destroyComponent(cid);
                            }

                            public void exceptionOccurred(Exception exception) {
                                cms.destroyComponent(cid);
                            }
                        });
                        ((IRequiredServicesFeature)InvokerAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITerminableService.class, cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITerminableService, Collection<TestReport>>((Future)ret){

                            public void customResultAvailable(final ITerminableService service) {
                                InvokerAgent.this.testTerminate(testno, service, delay).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Collection<TestReport>>((Future)ret){

                                    public void customResultAvailable(TestReport result) {
                                        ret.addIntermediateResult((Object)result);
                                        InvokerAgent.this.testTerminateAction(testno + 1, service, delay).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Collection<TestReport>>((Future)ret){

                                            public void customResultAvailable(TestReport result) {
                                                ret.addIntermediateResult((Object)result);
                                                ret.setFinished();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                }));
            }
        });
        return ret;
    }

    protected IFuture<TestReport> testTerminate(int testno, ITerminableService service, long delay) {
        final Future tmp = new Future();
        ITerminableFuture<String> fut = service.getResult(delay);
        fut.addResultListener((IResultListener)new IResultListener<String>(){

            public void resultAvailable(String result) {
                tmp.setException((Exception)new RuntimeException("Termination did not occur: " + result));
            }

            public void exceptionOccurred(Exception exception) {
                if (exception instanceof FutureTerminatedException) {
                    tmp.setResult(null);
                } else {
                    tmp.setException((Exception)new RuntimeException("Wrong exception occurred: " + exception));
                }
            }
        });
        fut.terminate();
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Tests if terminating future works");
        tmp.addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

            public void customResultAvailable(Void result) {
                tr.setSucceeded(true);
                ret.setResult((Object)tr);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed(exception.getMessage());
                ret.setResult((Object)tr);
            }
        });
        return ret;
    }

    protected IFuture<TestReport> testTerminateAction(int testno, ITerminableService service, long delay) {
        final Future tmp = new Future();
        final ITerminableFuture<String> fut = service.getResult(delay);
        service.terminateCalled().addResultListener((IResultListener)new IntermediateExceptionDelegationResultListener<Void, Void>(tmp){

            public void intermediateResultAvailable(Void result) {
                fut.terminate();
            }

            public void customResultAvailable(Collection<Void> result) {
                tmp.setResult(null);
            }

            public void finished() {
                tmp.setResult(null);
            }
        });
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Tests if terminating action of future is called");
        tmp.addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

            public void customResultAvailable(Void result) {
                tr.setSucceeded(true);
                ret.setResult((Object)tr);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed(exception.getMessage());
                ret.setResult((Object)tr);
            }
        });
        return ret;
    }
}

