/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.terminate;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.impl.IInternalExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.ITerminableFuture;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.IntermediateFuture;
import jadex.commons.future.TerminableFuture;
import jadex.commons.future.TerminableIntermediateFuture;
import jadex.commons.future.TerminationCommand;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.testcases.terminate.ITerminableService;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=ITerminableService.class, implementation=@Implementation(expression="$pojoagent"))})
@Description(value="Agent that provides a service with terminable future results")
public class TerminableProviderAgent
implements ITerminableService {
    @Agent
    protected IInternalAccess agent;
    protected IntermediateFuture<Void> termfut;

    @Override
    public ITerminableFuture<String> getResult(long delay) {
        final TerminableFuture ret = new TerminableFuture((ITerminationCommand)new TerminationCommand(){

            public void terminated(Exception reason) {
                if (TerminableProviderAgent.this.termfut != null) {
                    if (!((IExecutionFeature)TerminableProviderAgent.this.agent.getComponentFeature(IExecutionFeature.class)).isComponentThread()) {
                        System.err.println("adapter0: " + TerminableProviderAgent.this.agent.getComponentIdentifier());
                        System.err.println("adapter0a: " + IInternalExecutionFeature.LOCAL.get());
                        Thread.dumpStack();
                        TerminableProviderAgent.this.termfut.setException((Exception)new RuntimeException("Terminate called on wrong thread."));
                    } else {
                        TerminableProviderAgent.this.termfut.setFinished();
                    }
                    TerminableProviderAgent.this.termfut = null;
                }
            }
        });
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                ret.setResultIfUndone((Object)"result");
                return null;
            }
        });
        return ret;
    }

    @Override
    public ITerminableIntermediateFuture<String> getResults(final long delay, final int max) {
        final TerminableIntermediateFuture ret = new TerminableIntermediateFuture(new ITerminationCommand(){

            public void terminated(Exception reason) {
                if (TerminableProviderAgent.this.termfut != null) {
                    if (!((IExecutionFeature)TerminableProviderAgent.this.agent.getComponentFeature(IExecutionFeature.class)).isComponentThread()) {
                        System.err.println("adapter1: " + TerminableProviderAgent.this.agent.getComponentIdentifier());
                        System.err.println("adapter1a: " + IInternalExecutionFeature.LOCAL.get());
                        Thread.dumpStack();
                        TerminableProviderAgent.this.termfut.setException((Exception)new RuntimeException("Terminate called on wrong thread."));
                    } else {
                        TerminableProviderAgent.this.termfut.setFinished();
                    }
                    TerminableProviderAgent.this.termfut = null;
                }
            }

            public boolean checkTermination(Exception reason) {
                return true;
            }
        });
        final int[] cnt = new int[1];
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                int n = cnt[0];
                cnt[0] = n + 1;
                if (ret.addIntermediateResultIfUndone((Object)("step(" + n + "/" + max + ")"))) {
                    if (cnt[0] == max) {
                        ret.setFinished();
                    } else {
                        ((IExecutionFeature)TerminableProviderAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, (IComponentStep)this);
                    }
                }
                return null;
            }
        });
        return ret;
    }

    @Override
    public IIntermediateFuture<Void> terminateCalled() {
        IntermediateFuture ret = new IntermediateFuture();
        if (this.termfut != null) {
            ret.setException((Exception)new RuntimeException("Must not be called twice before result is available"));
        } else {
            ret.addIntermediateResult(null);
            this.termfut = ret;
        }
        return ret;
    }
}

