/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.threading;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.threading.ITestService;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global"))})
public class InitiatorAgent
extends TestAgent {
    private int maxLocal = 10000;
    private int maxRemote = 1000;

    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        if (SReflect.isAndroid()) {
            this.maxLocal /= 100;
            this.maxRemote /= 100;
        }
        this.testLocal(1, this.maxLocal).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                InitiatorAgent.this.testRemote(2, InitiatorAgent.this.maxRemote).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(int testno, int max) {
        final Future ret = new Future();
        System.out.println("Test local: " + this.agent.getModel().getFullName());
        this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, max, true).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

            public void customResultAvailable(TestReport result) {
                ret.setResult((Object)result);
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testRemote(final int testno, final int max) {
        final Future ret = new Future();
        System.out.println("Test remote: " + this.agent.getModel().getFullName());
        this.setupRemotePlatform(false).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                System.out.println("Test remote1: " + InitiatorAgent.this.agent.getModel().getFullName());
                InitiatorAgent.this.performTest(platform.getComponentIdentifier(), testno, max, false).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno, final int max, final boolean local) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Test if " + (local ? "local" : "remote") + " thread decoupling works.");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent("jadex/micro/testcases/threading/ProviderAgent.class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(IComponentIdentifier cid) {
                InitiatorAgent.this.callService(cid, local, testno, max).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return res;
    }

    protected IFuture<TestReport> callService(IComponentIdentifier cid, boolean local, int testno, final int max) {
        final Future ret = new Future();
        System.out.println("Call service: " + this.agent.getModel().getFullName());
        final TestReport tr = new TestReport("#" + testno, "Test if " + (local ? "local" : "remote") + " thread decoupling works.");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITestService.class, cid);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, TestReport>(ret){

            public void customResultAvailable(ITestService ts) {
                final long start = System.currentTimeMillis();
                InitiatorAgent.this.invoke(ts, 0, max).addResultListener((IResultListener)new ExceptionDelegationResultListener<Integer, TestReport>(ret){

                    public void customResultAvailable(Integer result) {
                        long dur = System.currentTimeMillis() - start;
                        System.out.println("Needed per call [ms]: " + (double)dur / (double)max);
                        System.out.println("Calls per second: " + (double)max / (double)dur * 1000.0);
                        if (result == 0) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setFailed("Invocations failed: " + result);
                        }
                        ret.setResult((Object)tr);
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Integer> invoke(final ITestService ts, final int i, final int max) {
        final Future ret = new Future();
        final IComponentIdentifier caller = (IComponentIdentifier)IComponentIdentifier.LOCAL.get();
        final int[] errcnt = new int[1];
        ts.testThreading().addResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                if (!caller.equals(IComponentIdentifier.LOCAL.get())) {
                    errcnt[0] = errcnt[0] + 1;
                    System.out.println("err: " + caller + " " + IComponentIdentifier.LOCAL.get());
                }
                if (i < max) {
                    InitiatorAgent.this.invoke(ts, i + 1, max).addResultListener((IResultListener)new DelegationResultListener(ret));
                } else {
                    ret.setResult((Object)errcnt[0]);
                }
            }

            public void exceptionOccurred(Exception exception) {
                errcnt[0] = errcnt[0] + 1;
                System.out.println("ex: " + exception);
                this.resultAvailable(null);
            }
        });
        return ret;
    }
}

