/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.timeout;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.component.interceptors.CallAccess;
import jadex.commons.Tuple2;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.timeout.ITestService;
import jadex.micro.testcases.timeout.ProviderAgent;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global"))})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                InitiatorAgent.this.testRemote(2).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(int testno) {
        final Future ret = new Future();
        this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, true).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

            public void customResultAvailable(TestReport result) {
                ret.setResult((Object)result);
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testRemote(final int testno) {
        final Future ret = new Future();
        this.setupRemotePlatform(false).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                InitiatorAgent.this.performTest(platform.getComponentIdentifier(), testno, false).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno, boolean hassectrans) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if timeout works.");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent(ProviderAgent.class.getName() + ".class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(IComponentIdentifier cid) {
                InitiatorAgent.this.callService(cid, testno, 5000L).addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                super.exceptionOccurred(exception);
            }
        });
        return res;
    }

    protected IFuture<TestReport> callService(IComponentIdentifier cid, int testno, final long to) {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Test if timeout works " + (to == -1L ? "without " : "with " + to) + " timeout.");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITestService.class, cid);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, TestReport>(ret){

            public void customResultAvailable(ITestService ts) {
                final long start = System.currentTimeMillis();
                if (to != -1L) {
                    ServiceCall call = ServiceCall.getOrCreateNextInvocation();
                    call.setTimeout(to);
                    call.setRealtime(Boolean.TRUE);
                    call.setProperty("extra", (Object)"somval");
                }
                System.out.println("calling method: " + ServiceCall.getOrCreateNextInvocation());
                ts.method("test1").addResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        tr.setFailed("No timeout occurred");
                        ret.setResult((Object)tr);
                    }

                    public void exceptionOccurred(Exception exception) {
                        ServiceCall next = CallAccess.getNextInvocation();
                        if (next != null) {
                            tr.setFailed("User invocation data still available: " + next);
                        } else if (exception instanceof TimeoutException) {
                            long diff = System.currentTimeMillis() - (start + to);
                            if (to == -1L || diff >= 0L && diff < Starter.getScaledLocalDefaultTimeout((IComponentIdentifier)InitiatorAgent.this.agent.getComponentIdentifier(), (double)0.06666666666666667)) {
                                tr.setSucceeded(true);
                            } else {
                                tr.setFailed("Timeout difference too high: " + diff);
                            }
                        } else {
                            tr.setFailed("No timeout occurred");
                        }
                        ret.setResult((Object)tr);
                    }
                });
            }
        });
        return ret;
    }
}

