/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.tuplefuture;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.DefaultTuple2ResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITuple2Future;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.CreationInfo;
import jadex.micro.annotation.Properties;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.tuplefuture.ITestService;

@Agent
@ComponentTypes(value={@ComponentType(name="ta", filename="jadex.micro.testcases.tuplefuture.ProviderAgent.class"), @ComponentType(name="ta2", filename="jadex.micro.testcases.tuplefuture.Provider2Agent.class")})
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global", create=true, creationinfo=@CreationInfo(type="ta")))})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Properties(value={@NameValue(name="test.timeout", value="jadex.base.Starter.getScaledLocalDefaultTimeout(null, 1.5)")})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        ITestService ts = (ITestService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("ts").get();
        ITuple2Future<String, Integer> fut = ts.getSomeResults();
        final TestReport tr1 = new TestReport("#1", "Test if blocking get works.");
        String res1 = (String)fut.getFirstResult();
        Integer res2 = (Integer)fut.getSecondResult();
        System.out.println("first result: " + res1);
        System.out.println("second result: " + res2);
        if ("hello".equals(res1) && res2 == 99) {
            tr1.setSucceeded(true);
        } else {
            tr1.setFailed("Received wrong results: " + res1 + " " + res2);
        }
        final TestReport tr2 = new TestReport("#2", "Test if default tuple2 listener works.");
        fut.addResultListener((IResultListener)new DefaultTuple2ResultListener<String, Integer>(){
            boolean[] res = new boolean[2];

            public void firstResultAvailable(String result) {
                System.out.println("first: " + result);
                if ("hello".equals(result)) {
                    this.res[0] = true;
                }
            }

            public void secondResultAvailable(Integer result) {
                System.out.println("second: " + result);
                if (result != null && result == 99) {
                    this.res[1] = true;
                }
            }

            public void finished() {
                System.out.println("finished: ");
                if (this.res[0] && this.res[1]) {
                    tr2.setSucceeded(true);
                } else {
                    tr2.setFailed("Received wrong results.");
                }
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(2, new TestReport[]{tr1, tr2}));
                UserAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("ex: " + exception);
                tr2.setFailed(exception);
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(2, new TestReport[]{tr1, tr2}));
                UserAgent.this.agent.killComponent();
            }
        });
    }
}

