/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import java.util.Date;

@Description(value="This agent uses the clock service.")
@Agent
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform"))})
public class ChatC2Agent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void executeBody() {
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice");
        fut.addResultListener((IResultListener)new DefaultResultListener<IClockService>(){

            public void resultAvailable(IClockService cs) {
                System.out.println("Time for a chat, buddy: " + new Date(cs.getTime()));
            }
        });
    }
}

