/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.tutorial.ChatServiceD1;
import jadex.micro.tutorial.IChatService;
import java.util.Collection;

@Description(value="This agent provides a basic chat service.")
@Agent
@ProvidedServices(value={@ProvidedService(type=IChatService.class, implementation=@Implementation(value=ChatServiceD1.class))})
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform")), @RequiredService(name="chatservices", type=IChatService.class, multiple=true, binding=@Binding(dynamic=true, scope="platform"))})
public class ChatD1Agent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void executeBody() {
        ITerminableIntermediateFuture chatservices = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("chatservices");
        chatservices.addResultListener((IResultListener)new DefaultResultListener<Collection<IChatService>>(){

            public void resultAvailable(Collection<IChatService> result) {
                for (IChatService cs : result) {
                    cs.message(ChatD1Agent.this.agent.getComponentIdentifier().getName(), "Hello");
                }
            }
        });
    }
}

