/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.tutorial.ChatServiceD5;
import jadex.micro.tutorial.IChatService;
import jadex.micro.tutorial.IRegistryServiceE3;
import java.util.Map;

@Description(value="This agent provides a basic chat service.")
@Agent
@ProvidedServices(value={@ProvidedService(type=IChatService.class, implementation=@Implementation(value=ChatServiceD5.class))})
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform")), @RequiredService(name="chatservices", type=IChatService.class, multiple=true, binding=@Binding(dynamic=true, scope="global")), @RequiredService(name="regservice", type=IRegistryServiceE3.class)})
@Arguments(value={@Argument(name="nickname", clazz=String.class, defaultvalue="\"Willi\"")})
public class ChatE3Agent {
    @Agent
    protected IInternalAccess agent;
    @AgentArgument
    protected String nickname;
    protected IRegistryServiceE3 regservice;

    @AgentCreated
    public IFuture<Void> init() {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("regservice");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IRegistryServiceE3, Void>(ret){

            public void customResultAvailable(IRegistryServiceE3 rs) {
                ChatE3Agent.this.regservice = rs;
                ret.setResult(null);
            }
        });
        return ret;
    }

    @AgentBody
    public void executeBody() {
        this.regservice.register(this.agent.getComponentIdentifier(), this.nickname);
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(10000L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                ChatE3Agent.this.regservice.getChatters().addResultListener((IResultListener)new DefaultResultListener<Map<String, IComponentIdentifier>>(){

                    public void resultAvailable(Map<String, IComponentIdentifier> result) {
                        System.out.println("The current chatters: " + result);
                    }
                });
                return IFuture.DONE;
            }
        });
    }
}

