/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.tutorial.ChatServiceD5;
import jadex.micro.tutorial.IChatService;
import jadex.micro.tutorial.IRegistryServiceE3;
import java.util.Map;

@Description(value="This agent provides a basic chat service.")
@Agent
@ProvidedServices(value={@ProvidedService(type=IChatService.class, implementation=@Implementation(value=ChatServiceD5.class))})
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="platform")), @RequiredService(name="chatservices", type=IChatService.class, multiple=true, binding=@Binding(dynamic=true, scope="global")), @RequiredService(name="regservice", type=IRegistryServiceE3.class)})
@Arguments(value={@Argument(name="nickname", clazz=String.class, defaultvalue="\"Willi\""), @Argument(name="partner", clazz=String.class)})
public class ChatE5Agent {
    @Agent
    protected IInternalAccess agent;
    @AgentArgument
    protected String nickname;
    @AgentArgument
    protected String partner;

    @AgentBody
    public void executeBody() {
        IFuture regservice = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("regservice");
        regservice.addResultListener((IResultListener)new DefaultResultListener<IRegistryServiceE3>(){

            public void resultAvailable(final IRegistryServiceE3 rs) {
                rs.register(ChatE5Agent.this.agent.getComponentIdentifier(), ChatE5Agent.this.nickname);
                ((IExecutionFeature)ChatE5Agent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(10000L, (IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        rs.getChatters().addResultListener((IResultListener)new DefaultResultListener<Map<String, IComponentIdentifier>>(){

                            public void resultAvailable(Map<String, IComponentIdentifier> chatters) {
                                System.out.println("The current chatters: " + chatters);
                                IComponentIdentifier cid = chatters.get(ChatE5Agent.this.partner);
                                if (cid == null) {
                                    System.out.println("Could not find chat partner named: " + ChatE5Agent.this.partner);
                                } else {
                                    ((IRequiredServicesFeature)ChatE5Agent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IChatService.class, cid).addResultListener((IResultListener)new DefaultResultListener<IChatService>(){

                                        public void resultAvailable(IChatService cs) {
                                            System.out.println("is on: " + IComponentIdentifier.LOCAL.get());
                                            cs.message(ChatE5Agent.this.agent.getComponentIdentifier().toString(), "Private hello from: " + ChatE5Agent.this.nickname);
                                        }
                                    });
                                }
                            }
                        });
                        return IFuture.DONE;
                    }
                });
            }
        });
    }
}

