/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.tutorial.IChatService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ChatGuiD2
extends JFrame {
    protected JTextArea received;

    public ChatGuiD2(final IExternalAccess agent) {
        super(agent.getComponentIdentifier().getName());
        this.setLayout(new BorderLayout());
        this.received = new JTextArea(10, 20);
        final JTextField message = new JTextField();
        JButton send = new JButton("send");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)message, "Center");
        panel.add((Component)send, "East");
        this.getContentPane().add((Component)new JScrollPane(this.received), "Center");
        this.getContentPane().add((Component)panel, "South");
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String text = message.getText();
                agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ITerminableIntermediateFuture chatservices = ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("chatservices");
                        chatservices.addResultListener((IResultListener)new DefaultResultListener<Collection<IChatService>>(){

                            public void resultAvailable(Collection<IChatService> result) {
                                for (IChatService cs : result) {
                                    cs.message(agent.getComponentIdentifier().getName(), text);
                                }
                            }
                        });
                        return IFuture.DONE;
                    }
                });
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                agent.killComponent();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void addMessage(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatGuiD2.this.received.append(text + "\n");
            }
        });
    }
}

