/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.tutorial.IChatService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ChatGuiD5
extends JFrame {
    protected JTextArea received;
    protected IExternalAccess agent;

    public ChatGuiD5(IExternalAccess agent) {
        super(agent.getComponentIdentifier().getName());
        this.agent = agent;
        this.setLayout(new BorderLayout());
        this.received = new JTextArea(10, 20);
        final JTextField message = new JTextField();
        JButton send = new JButton("send");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)message, "Center");
        panel.add((Component)send, "East");
        this.getContentPane().add((Component)this.received, "Center");
        this.getContentPane().add((Component)panel, "South");
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String text = message.getText();
                ChatGuiD5.this.agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ITerminableIntermediateFuture fut = ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("chatservices");
                        fut.addResultListener((IResultListener)new IIntermediateResultListener<IChatService>(){

                            public void resultAvailable(Collection<IChatService> result) {
                                for (IChatService cs : result) {
                                    try {
                                        cs.message(ChatGuiD5.this.agent.getComponentIdentifier().getName(), text);
                                    }
                                    catch (Exception e) {
                                        System.out.println("Could not send message to: " + cs);
                                    }
                                }
                            }

                            public void intermediateResultAvailable(IChatService cs) {
                                System.out.println("found: " + cs);
                                cs.message(ChatGuiD5.this.agent.getComponentIdentifier().getName(), text);
                            }

                            public void finished() {
                            }

                            public void exceptionOccurred(Exception exception) {
                            }
                        });
                        return IFuture.DONE;
                    }
                });
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ChatGuiD5.this.agent.killComponent();
                ChatGuiD5.this.agent = null;
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void addMessage(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatGuiD5.this.received.append(text + "\n");
            }
        });
    }
}

