/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.tutorial.IChatService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@Service
public class ChatServiceD1
implements IChatService {
    @ServiceComponent
    protected IInternalAccess agent;
    protected IClockService clock;
    protected DateFormat format;

    @ServiceStart
    public IFuture<Void> startService() {
        final Future ret = new Future();
        this.format = new SimpleDateFormat("hh:mm:ss");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IClockService, Void>(ret){

            public void customResultAvailable(IClockService result) {
                ChatServiceD1.this.clock = result;
                ret.setResult(null);
            }
        });
        return ret;
    }

    @Override
    public void message(String sender, String text) {
        System.out.println(this.agent.getComponentIdentifier().getLocalName() + " received at " + this.format.format(new Date(this.clock.getTime())) + " from: " + sender + " message: " + text);
    }
}

