/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceShutdown;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.micro.tutorial.ChatGuiD2;
import jadex.micro.tutorial.IChatService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;

@Service
public class ChatServiceD2
implements IChatService {
    @ServiceComponent
    protected IInternalAccess agent;
    protected IClockService clock;
    protected DateFormat format;
    protected ChatGuiD2 gui;

    @ServiceStart
    public IFuture<Void> startService() {
        final Future ret = new Future();
        this.format = new SimpleDateFormat("hh:mm:ss");
        final IExternalAccess exta = this.agent.getExternalAccess();
        IFuture clockservice = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice");
        clockservice.addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IClockService, Void>(ret){

            public void customResultAvailable(IClockService result) {
                ChatServiceD2.this.clock = result;
                ChatServiceD2.this.gui = ChatServiceD2.this.createGui(exta);
                ret.setResult(null);
            }
        });
        return ret;
    }

    @ServiceShutdown
    public void shutdownService() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatServiceD2.this.gui.dispose();
            }
        });
    }

    @Override
    public void message(String sender, String text) {
        this.gui.addMessage(this.agent.getComponentIdentifier().getLocalName() + " received at " + this.format.format(new Date(this.clock.getTime())) + " from: " + sender + " message: " + text);
    }

    protected ChatGuiD2 createGui(IExternalAccess agent) {
        return new ChatGuiD2(agent);
    }
}

