/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.tutorial;

import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceShutdown;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.micro.tutorial.ChatGuiD5;
import jadex.micro.tutorial.IChatService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;

@Service
public class ChatServiceD5
implements IChatService {
    @ServiceComponent
    protected IInternalAccess agent;
    protected IClockService clock;
    protected DateFormat format;
    protected ChatGuiD5 gui;

    @ServiceStart
    public IFuture<Void> startService() {
        final Future ret = new Future();
        this.format = new SimpleDateFormat("hh:mm:ss");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice");
        fut.addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IClockService, Void>(ret){

            public void customResultAvailable(IClockService result) {
                ChatServiceD5.this.clock = result;
                ChatServiceD5.this.gui = ChatServiceD5.this.createGui(ChatServiceD5.this.agent.getExternalAccess());
                ret.setResult(null);
            }
        });
        return ret;
    }

    @ServiceShutdown
    public void shutdownService() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatServiceD5.this.gui.dispose();
            }
        });
    }

    @Override
    public void message(String sender, String text) {
        this.gui.addMessage(this.agent.getComponentIdentifier().getLocalName() + " received at " + this.format.format(new Date(this.clock.getTime())) + " from: " + sender + " message: " + text);
    }

    protected ChatGuiD5 createGui(IExternalAccess agent) {
        return new ChatGuiD5(agent);
    }
}

