/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld;

import jadex.base.IPlatformConfiguration;
import jadex.base.PlatformConfigurationHandler;
import jadex.base.Starter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.ServiceQuery;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.threadpool.IThreadPoolService;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.future.IFuture;
import jadex.quickstart.cleanerworld.gui.EnvironmentGui;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class Main {
    protected static double CLOCK_SPEED = 1.0;

    public static void main(String[] args) {
        IPlatformConfiguration conf = PlatformConfigurationHandler.getMinimal();
        conf.setLoggingLevel(Level.WARNING);
        conf.setValue("kernel_bdi", (Object)true);
        conf.addComponent("jadex/quickstart/cleanerworld/single/CleanerBDIAgentA2.class");
        IFuture fut = Starter.createPlatform((IPlatformConfiguration)conf);
        fut.get();
        IClockService cs = (IClockService)((IExternalAccess)fut.get()).searchService(new ServiceQuery(IClockService.class)).get();
        cs.setClock("continuous", (IThreadPool)((IExternalAccess)fut.get()).searchService(new ServiceQuery(IThreadPoolService.class)).get());
        cs.setDilation(CLOCK_SPEED);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EnvironmentGui().setVisible(true);
            }
        });
    }
}

