/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.impl.ExecutionComponentFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.ServiceQuery;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.commons.ErrorException;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.ILocation;
import jadex.quickstart.cleanerworld.environment.ILocationObject;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.impl.Cleaner;
import jadex.quickstart.cleanerworld.environment.impl.Environment;
import jadex.quickstart.cleanerworld.environment.impl.Location;
import jadex.quickstart.cleanerworld.environment.impl.LocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Pheromone;
import jadex.quickstart.cleanerworld.environment.impl.Waste;
import jadex.quickstart.cleanerworld.environment.impl.Wastebin;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class SensorActuator {
    public IInternalAccess agent = (IInternalAccess)ExecutionComponentFeature.LOCAL.get();
    private Cleaner self;
    private Location target;
    private String pheromone;
    private Set<ICleaner> cleaners;
    private Set<IWaste> wastes;
    private Set<IChargingstation> chargingstations;
    private Set<IWastebin> wastebins;
    private Future<Void> recharging;

    public SensorActuator() {
        if (this.agent == null) {
            throw new IllegalStateException("Must be called on agent thread. Failed to find agent for sensor/actuator.");
        }
        this.self = Environment.getInstance().createCleaner(this.agent);
        this.cleaners = new LinkedHashSet<ICleaner>();
        this.wastes = new LinkedHashSet<IWaste>();
        this.chargingstations = new LinkedHashSet<IChargingstation>();
        this.wastebins = new LinkedHashSet<IWastebin>();
    }

    public ICleaner getSelf() {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        return this.self;
    }

    public boolean isDaytime() {
        return Environment.getInstance().getDaytime();
    }

    public Set<ICleaner> getCleaners() {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        return this.cleaners;
    }

    public Set<IWaste> getWastes() {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        return this.wastes;
    }

    public Set<IChargingstation> getChargingstations() {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        return this.chargingstations;
    }

    public Set<IWastebin> getWastebins() {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        return this.wastebins;
    }

    public void manageWastesIn(Set<IWaste> wastes) {
        wastes.addAll(this.wastes);
        this.wastes = wastes;
    }

    public void manageWastebinsIn(Set<IWastebin> wastebins) {
        wastebins.addAll(this.wastebins);
        this.wastebins = wastebins;
    }

    public void manageChargingstationsIn(Set<IChargingstation> chargingstations) {
        chargingstations.addAll(this.chargingstations);
        this.chargingstations = chargingstations;
    }

    public void manageCleanersIn(Set<ICleaner> cleaners) {
        cleaners.addAll(this.cleaners);
        this.cleaners = cleaners;
    }

    public void moveTo(ILocation location) {
        this.moveTo(location.getX(), location.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(double x, double y) {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        if (this.target != null) {
            throw new IllegalStateException("Cannot move to multiple targets simultaneously. Target exists: " + this.target);
        }
        if (this.self.getChargestate() <= 0.0) {
            if (this.recharging == null) {
                this.recharging = new Future();
            }
            this.agent.getLogger().warning("moveTo() called with empty battery -> blocking until recharged.");
            this.recharging.get();
        }
        this.target = new Location(x, y);
        final Future reached = new Future();
        if (this.self.getLocation().isNear(this.target)) {
            reached.setResultIfUndone(null);
        } else {
            final IClockService clock = (IClockService)((IRequiredServicesFeature)this.agent.getFeature(IRequiredServicesFeature.class)).getLocalService(new ServiceQuery(IClockService.class));
            clock.createTickTimer(new ITimedObject(){
                long lasttime;
                ITimedObject timer;
                {
                    this.lasttime = clock.getTime();
                    this.timer = this;
                }

                public void timeEventOccurred(final long currenttime) {
                    if (!reached.isDone()) {
                        ((IExecutionFeature)SensorActuator.this.agent.getFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                            public IFuture<Void> execute(IInternalAccess ia) {
                                double delta = (double)(currenttime - lasttime) / 1000.0;
                                double chargestate = SensorActuator.this.self.getChargestate() - delta / 100.0;
                                if (chargestate < 0.0) {
                                    SensorActuator.this.self.setChargestate(0.0);
                                    return new Future((Exception)new IllegalStateException("Run of battery during moveTo() -> target location not reached!"));
                                }
                                SensorActuator.this.self.setChargestate(chargestate);
                                double total_dist = SensorActuator.this.self.getLocation().getDistance(SensorActuator.this.target);
                                double move_dist = Math.min(total_dist, 0.1 * delta);
                                double dx = (SensorActuator.this.target.getX() - SensorActuator.this.self.getLocation().getX()) * move_dist / total_dist;
                                double dy = (SensorActuator.this.target.getY() - SensorActuator.this.self.getLocation().getY()) * move_dist / total_dist;
                                SensorActuator.this.self.setLocation(new Location(SensorActuator.this.self.getLocation().getX() + dx, SensorActuator.this.self.getLocation().getY() + dy));
                                Environment.getInstance().updateCleaner(SensorActuator.this.self);
                                if (SensorActuator.this.pheromone != null) {
                                    Pheromone ph = new Pheromone(SensorActuator.this.self.getLocation(), SensorActuator.this.pheromone);
                                    Environment.getInstance().addPheromone(ph);
                                }
                                SensorActuator.this.update();
                                if (SensorActuator.this.self.getLocation().isNear(SensorActuator.this.target)) {
                                    reached.setResultIfUndone(null);
                                } else {
                                    lasttime = currenttime;
                                    clock.createTickTimer(timer);
                                }
                                return IFuture.DONE;
                            }
                        }).addResultListener((IResultListener)new IResultListener<Void>(){

                            public void exceptionOccurred(Exception exception) {
                                reached.setExceptionIfUndone(exception);
                            }

                            public void resultAvailable(Void result) {
                            }
                        });
                    }
                }
            });
        }
        try {
            reached.get();
        }
        catch (Throwable t) {
            reached.setExceptionIfUndone(t instanceof Exception ? (Exception)t : new ErrorException((Error)t));
            SUtil.throwUnchecked((Throwable)t);
        }
        finally {
            this.target = null;
            this.pheromone = null;
        }
    }

    public synchronized void recharge(final IChargingstation chargingstation, final double level) {
        if (!((IExecutionFeature)this.agent.getFeature(IExecutionFeature.class)).isComponentThread()) {
            throw new IllegalStateException("Error: Must be called on agent thread.");
        }
        final Future reached = new Future();
        final IClockService clock = (IClockService)((IRequiredServicesFeature)this.agent.getFeature(IRequiredServicesFeature.class)).getLocalService(new ServiceQuery(IClockService.class));
        clock.createTickTimer(new ITimedObject(){
            long lasttime;
            ITimedObject timer;
            {
                this.lasttime = clock.getTime();
                this.timer = this;
            }

            public void timeEventOccurred(final long currenttime) {
                if (!reached.isDone()) {
                    ((IExecutionFeature)SensorActuator.this.agent.getFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                        public IFuture<Void> execute(IInternalAccess ia) {
                            if (!SensorActuator.this.self.getLocation().isNear(chargingstation.getLocation())) {
                                throw new IllegalStateException("Cannot not recharge. Charging station out of reach!");
                            }
                            double delta = (double)(currenttime - lasttime) / 1000.0;
                            double inc = delta / 10.0;
                            if (SensorActuator.this.self.getChargestate() > 0.7) {
                                inc = inc * 10.0 / 3.0 * (1.0 - SensorActuator.this.self.getChargestate());
                            }
                            SensorActuator.this.self.setChargestate(SensorActuator.this.self.getChargestate() + inc);
                            Future<Void> rec = SensorActuator.this.recharging;
                            SensorActuator.this.recharging = null;
                            if (rec != null) {
                                rec.setResult(null);
                            }
                            Environment.getInstance().updateCleaner(SensorActuator.this.self);
                            if (SensorActuator.this.self.getChargestate() >= level) {
                                reached.setResultIfUndone(null);
                            } else {
                                lasttime = currenttime;
                                clock.createTickTimer(timer);
                            }
                            return null;
                        }
                    }).addResultListener((IResultListener)new IResultListener<Void>(){

                        public void exceptionOccurred(Exception exception) {
                            reached.setExceptionIfUndone(exception);
                        }

                        public void resultAvailable(Void result) {
                        }
                    });
                }
            }
        });
        try {
            reached.get();
        }
        catch (Throwable t) {
            reached.setExceptionIfUndone(t instanceof Exception ? (Exception)t : new ErrorException((Error)t));
            SUtil.throwUnchecked((Throwable)t);
        }
    }

    public ILocation getTarget() {
        return this.target;
    }

    public void pickUpWaste(IWaste waste) {
        Environment.getInstance().pickupWaste(this.self, (Waste)waste);
        this.self.setCarriedWaste((Waste)waste);
        this.wastes.remove(waste);
        ((Waste)waste).setLocation(null);
    }

    public void dropWasteInWastebin(IWaste waste, IWastebin wastebin) {
        Environment.getInstance().dropWasteInWastebin(this.self, (Waste)waste, (Wastebin)wastebin);
        this.self.setCarriedWaste(null);
        ((Wastebin)wastebin).addWaste(waste);
    }

    void update() {
        this.updateObjects(this.cleaners, Environment.getInstance().getCleaners());
        this.updateObjects(this.wastes, Environment.getInstance().getWastes());
        this.updateObjects(this.chargingstations, Environment.getInstance().getChargingstations());
        this.updateObjects(this.wastebins, Environment.getInstance().getWastebins());
    }

    <T extends ILocationObject> void updateObjects(Set<T> oldset, T[] newset) {
        LinkedHashMap<T, T> newmap = new LinkedHashMap<T, T>();
        for (T t : newset) {
            if (t.equals(this.self)) {
                this.self.update((Cleaner)t);
                continue;
            }
            newmap.put(t, t);
        }
        for (T t : oldset.toArray(new LocationObject[oldset.size()])) {
            LocationObject newobj = (LocationObject)newmap.remove(t);
            if (((LocationObject)t).getLocation().getDistance(this.self.getLocation()) <= this.self.getVisionRange() && (newobj == null || newobj.getLocation().getDistance(this.self.getLocation()) > this.self.getVisionRange())) {
                oldset.remove(t);
            }
            if (newobj == null || !(newobj.getLocation().getDistance(this.self.getLocation()) <= this.self.getVisionRange())) continue;
            ((LocationObject)t).update(newobj);
        }
        for (ILocationObject newobj : newmap.values()) {
            if (!(newobj.getLocation().getDistance(this.self.getLocation()) <= this.self.getVisionRange())) continue;
            oldset.add((LocationObject)newobj);
        }
    }
}

