/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.impl.Location;
import jadex.quickstart.cleanerworld.environment.impl.LocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Waste;

public class Cleaner
extends LocationObject
implements ICleaner {
    private IComponentIdentifier cid;
    private double chargestate;
    private Waste carriedwaste;
    private double visionrange;

    public Cleaner() {
    }

    public Cleaner(IComponentIdentifier cid, Location location, Waste carriedwaste, double vision, double chargestate) {
        super(cid.getName(), location);
        this.cid = cid;
        this.setCarriedWaste(carriedwaste);
        this.setVisionRange(vision);
        this.setChargestate(chargestate);
    }

    @Override
    public IComponentIdentifier getAgentIdentifier() {
        return this.cid;
    }

    public void setAgentIdentifier(IComponentIdentifier cid) {
        this.cid = cid;
    }

    @Override
    public double getChargestate() {
        return this.chargestate;
    }

    public void setChargestate(double chargestate) {
        double oldcs = this.chargestate;
        this.chargestate = chargestate;
        this.pcs.firePropertyChange("chargestate", (Object)oldcs, (Object)chargestate);
    }

    @Override
    public Waste getCarriedWaste() {
        return this.carriedwaste;
    }

    public void setCarriedWaste(Waste carriedwaste) {
        Waste oldcw = this.carriedwaste;
        this.carriedwaste = carriedwaste;
        this.pcs.firePropertyChange("carriedWaste", (Object)oldcw, (Object)carriedwaste);
    }

    @Override
    public double getVisionRange() {
        return this.visionrange;
    }

    public void setVisionRange(double visionrange) {
        double oldvr = this.visionrange;
        this.visionrange = visionrange;
        this.pcs.firePropertyChange("visionRange", (Object)oldvr, (Object)visionrange);
    }

    public void update(Cleaner cl) {
        assert (this.getId().equals(cl.getId()));
        super.update(cl);
        this.setChargestate(cl.getChargestate());
        this.setVisionRange(cl.getVisionRange());
        if (SUtil.equals((Object)this.getCarriedWaste(), (Object)cl.getCarriedWaste())) {
            this.setCarriedWaste(cl.getCarriedWaste());
        }
    }

    public String toString() {
        return "Cleaner(id=" + this.getId() + ", location=" + this.getLocation() + ")";
    }

    @Override
    public Cleaner clone() {
        Cleaner clone = (Cleaner)super.clone();
        if (this.getCarriedWaste() != null) {
            clone.setCarriedWaste(this.getCarriedWaste().clone());
        }
        return clone;
    }
}

