/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.types.cms.CMSStatusEvent;
import jadex.bridge.service.types.cms.SComponentManagementService;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateEmptyResultListener;
import jadex.quickstart.cleanerworld.environment.ILocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Chargingstation;
import jadex.quickstart.cleanerworld.environment.impl.Cleaner;
import jadex.quickstart.cleanerworld.environment.impl.Location;
import jadex.quickstart.cleanerworld.environment.impl.LocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Pheromone;
import jadex.quickstart.cleanerworld.environment.impl.Waste;
import jadex.quickstart.cleanerworld.environment.impl.Wastebin;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Environment {
    private static Environment instance;
    private boolean daytime = true;
    private Map<IComponentIdentifier, Cleaner> cleaners = new LinkedHashMap<IComponentIdentifier, Cleaner>();
    private List<Waste> wastes = new ArrayList<Waste>();
    private List<Wastebin> wastebins = new ArrayList<Wastebin>();
    private List<Chargingstation> chargingstations = new ArrayList<Chargingstation>();
    private List<Pheromone> pheromones = new ArrayList<Pheromone>();

    private Environment() {
        this.addWaste(new Waste(new Location(0.1, 0.5)));
        this.addWaste(new Waste(new Location(0.2, 0.5)));
        this.addWaste(new Waste(new Location(0.3, 0.5)));
        this.addWaste(new Waste(new Location(0.9, 0.9)));
        this.addWastebin(new Wastebin(new Location(0.2, 0.2), 20));
        this.addWastebin(new Wastebin(new Location(0.8, 0.1), 20));
        this.addChargingStation(new Chargingstation(new Location(0.775, 0.775)));
        this.addChargingStation(new Chargingstation(new Location(0.15, 0.4)));
    }

    public static synchronized Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cleaner createCleaner(IInternalAccess agent) {
        boolean create;
        Cleaner ret;
        final IComponentIdentifier cid = agent.getId();
        Environment environment = this;
        synchronized (environment) {
            ret = this.cleaners.get(cid);
            boolean bl = create = ret == null;
            if (create) {
                ret = new Cleaner(cid, new Location(Math.random() * 0.4 + 0.3, Math.random() * 0.4 + 0.3), null, 0.1, 0.8);
                this.cleaners.put(cid, ret);
            }
        }
        if (!create) {
            throw new IllegalStateException("Cleaner for agent " + cid + " already exists (duplicate actsense?).");
        }
        SComponentManagementService.listenToComponent((IComponentIdentifier)cid, (IInternalAccess)agent).addResultListener((IResultListener)new IntermediateEmptyResultListener<CMSStatusEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void intermediateResultAvailable(CMSStatusEvent cse) {
                if (cse instanceof CMSStatusEvent.CMSTerminatedEvent) {
                    Environment environment = Environment.this;
                    synchronized (environment) {
                        Environment.this.cleaners.remove(cid);
                    }
                }
            }
        });
        return ret.clone();
    }

    public synchronized boolean getDaytime() {
        return this.daytime;
    }

    public synchronized void setDaytime(boolean daytime) {
        this.daytime = daytime;
    }

    public synchronized void addWaste(Waste waste) {
        this.wastes.add(waste.clone());
    }

    public synchronized boolean removeWaste(Waste waste) {
        boolean ret = this.wastes.remove(waste);
        return ret;
    }

    public synchronized void addWastebin(Wastebin wastebin) {
        this.wastebins.add(wastebin.clone());
    }

    public synchronized void addChargingStation(Chargingstation station) {
        this.chargingstations.add(station.clone());
    }

    public synchronized void addPheromone(Pheromone pheromone) {
        this.pheromones.add(pheromone.clone());
    }

    public synchronized Waste[] getWastes() {
        return (Waste[])Environment.cloneList(this.wastes, Waste.class);
    }

    public synchronized Wastebin[] getWastebins() {
        return (Wastebin[])Environment.cloneList(this.wastebins, Wastebin.class);
    }

    public synchronized Chargingstation[] getChargingstations() {
        return (Chargingstation[])Environment.cloneList(this.chargingstations, Chargingstation.class);
    }

    public synchronized Cleaner[] getCleaners() {
        return (Cleaner[])Environment.cloneList(this.cleaners.values(), Cleaner.class);
    }

    public synchronized Pheromone[] getPheromones() {
        Iterator<Pheromone> phi = this.pheromones.iterator();
        while (phi.hasNext() && phi.next().getStrength() == 0.0) {
            phi.remove();
        }
        return (Pheromone[])Environment.cloneList(this.pheromones, Pheromone.class);
    }

    public synchronized void updateCleaner(Cleaner cleaner) {
        this.cleaners.put(cleaner.getAgentIdentifier(), cleaner.clone());
    }

    public synchronized void pickupWaste(Cleaner cleaner, Waste waste) {
        Cleaner mycleaner = this.cleaners.get(cleaner.getAgentIdentifier());
        if (mycleaner.getCarriedWaste() != null) {
            throw new RuntimeException("Cleaner already carries waste: " + waste);
        }
        Waste mywaste = null;
        for (Waste w : this.wastes) {
            if (!w.equals(waste)) continue;
            mywaste = w;
        }
        if (mywaste == null) {
            throw new RuntimeException("No such waste: " + waste);
        }
        if (!mycleaner.getLocation().isNear(waste.getLocation())) {
            throw new RuntimeException("Cleaner not in pickup range: " + mycleaner + ", " + mywaste);
        }
        mywaste.setLocation(null);
        mycleaner.setCarriedWaste(mywaste);
        this.wastes.remove(waste);
    }

    public synchronized void dropWasteInWastebin(Cleaner cleaner, Waste waste, Wastebin wastebin) {
        Cleaner mycleaner = this.cleaners.get(cleaner.getAgentIdentifier());
        if (mycleaner.getCarriedWaste() == null || !mycleaner.getCarriedWaste().equals(waste)) {
            throw new RuntimeException("Cleaner does not carry the waste: " + cleaner + ", " + waste);
        }
        Wastebin mywastebin = null;
        for (Wastebin wb : this.wastebins) {
            if (!wb.equals(wastebin)) continue;
            mywastebin = wb;
        }
        if (mywastebin == null) {
            throw new RuntimeException("No such waste bin: " + wastebin);
        }
        if (!mycleaner.getLocation().isNear(wastebin.getLocation())) {
            throw new RuntimeException("Cleaner not in drop range: " + mycleaner + ", " + mywastebin);
        }
        mywastebin.addWaste(waste.clone());
        mycleaner.setCarriedWaste(null);
    }

    public synchronized Wastebin getWastebin(String name) {
        Wastebin ret = null;
        for (Wastebin wb : this.wastebins) {
            if (!wb.getId().equals(name)) continue;
            ret = wb;
            break;
        }
        return ret;
    }

    public static <T extends ILocationObject> T[] cloneList(Collection<T> list, Class<T> type) {
        ArrayList<LocationObject> ret = new ArrayList<LocationObject>();
        for (ILocationObject o : list) {
            ret.add(((LocationObject)o).clone());
        }
        ILocationObject[] aret = ret.toArray((ILocationObject[])Array.newInstance(type, list.size()));
        return aret;
    }
}

