/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.quickstart.cleanerworld.environment.ILocation;

public class Location
implements ILocation,
Cloneable {
    public static final double DEFAULT_TOLERANCE = 0.001;
    private double x;
    private double y;

    public Location() {
    }

    public Location(double x, double y) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("x is not a number: " + x);
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException("y is not a number: " + y);
        }
        this.setX(x);
        this.setY(y);
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public String toString() {
        return "Location(x=" + this.getX() + ", y=" + this.getY() + ")";
    }

    @Override
    public double getDistance(ILocation other) {
        assert (other != null);
        return Math.sqrt((other.getY() - this.y) * (other.getY() - this.y) + (other.getX() - this.x) * (other.getX() - this.x));
    }

    @Override
    public boolean isNear(ILocation other) {
        return this.isNear(other, 0.001);
    }

    public boolean isNear(ILocation other, double tolerance) {
        return this.getDistance(other) <= tolerance;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof Location) {
            Location loc = (Location)o;
            if (loc.x == this.x && loc.y == this.y) {
                ret = true;
            }
        }
        return ret;
    }

    public int hashCode() {
        return (int)(this.x * 21.0 + this.y);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            throw new RuntimeException("Clone not supported");
        }
    }
}

