/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.commons.SimplePropertyChangeSupport;
import jadex.commons.beans.PropertyChangeListener;
import jadex.quickstart.cleanerworld.environment.ILocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Location;

public abstract class LocationObject
implements ILocationObject,
Cloneable {
    private String id;
    private Location location;
    SimplePropertyChangeSupport pcs = new SimplePropertyChangeSupport((Object)this);

    public LocationObject() {
    }

    public LocationObject(String id, Location location) {
        this();
        this.setId(id);
        this.setLocation(location);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldid = this.id;
        this.id = id;
        this.pcs.firePropertyChange("id", (Object)oldid, (Object)id);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        Location oldloc = this.location;
        this.location = location;
        this.pcs.firePropertyChange("location", (Object)oldloc, (Object)location);
    }

    public boolean equals(Object o) {
        return o instanceof LocationObject && ((LocationObject)o).id.equals(this.id) && o.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return 31 + this.id.hashCode();
    }

    public void update(LocationObject obj) {
        assert (this.getId().equals(obj.getId()));
        this.setLocation(obj.getLocation());
    }

    public LocationObject clone() {
        try {
            LocationObject clone = (LocationObject)super.clone();
            if (this.getLocation() != null) {
                clone.setLocation((Location)this.getLocation().clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected SimplePropertyChangeSupport getPropertyChangeHandler() {
        return this.pcs;
    }
}

