/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.bridge.IInternalAccess;
import jadex.bridge.component.impl.ExecutionComponentFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.ServiceQuery;
import jadex.bridge.service.types.clock.IClockService;
import jadex.quickstart.cleanerworld.environment.IPheromone;
import jadex.quickstart.cleanerworld.environment.impl.Location;
import jadex.quickstart.cleanerworld.environment.impl.LocationObject;

public class Pheromone
extends LocationObject
implements IPheromone {
    private static int instancecnt;
    private String type;
    private long creation;
    private IClockService clock;

    private static synchronized int getNumber() {
        return ++instancecnt;
    }

    public Pheromone() {
    }

    public Pheromone(Location location, String type) {
        super("Pheromone_#" + Pheromone.getNumber(), location);
        this.type = type;
        if (ExecutionComponentFeature.LOCAL.get() == null) {
            throw new IllegalStateException("Pheromone needs to be created on agent thread.");
        }
        this.clock = (IClockService)((IRequiredServicesFeature)((IInternalAccess)ExecutionComponentFeature.LOCAL.get()).getFeature(IRequiredServicesFeature.class)).getLocalService(new ServiceQuery(IClockService.class));
        this.creation = this.clock.getTime();
    }

    public String toString() {
        return "Pheromone(type=" + this.getType() + ", strength=" + this.getStrength() + ", location=" + this.getLocation() + ")";
    }

    @Override
    public Pheromone clone() {
        return (Pheromone)super.clone();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IClockService getClock() {
        return this.clock;
    }

    public void setClock(IClockService clock) {
        this.clock = clock;
    }

    @Override
    public double getStrength() {
        double age = (double)(this.clock.getTime() - this.creation) / 1000.0;
        return Math.max(0.0, 1.0 - age * 0.05);
    }
}

