/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.environment.impl;

import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.impl.Location;
import jadex.quickstart.cleanerworld.environment.impl.LocationObject;
import jadex.quickstart.cleanerworld.environment.impl.Waste;
import java.util.ArrayList;
import java.util.List;

public class Wastebin
extends LocationObject
implements IWastebin {
    private static int instancecnt = 0;
    private List<IWaste> wastes = new ArrayList<IWaste>();
    private int capacity;

    private static synchronized int getNumber() {
        return ++instancecnt;
    }

    public Wastebin() {
    }

    public Wastebin(Location location, int capacity) {
        super("Wastebin #" + Wastebin.getNumber(), location);
        this.setCapacity(capacity);
    }

    public Waste[] getWastes() {
        return this.wastes.toArray(new Waste[this.wastes.size()]);
    }

    public void setWastes(Waste[] wastes) {
        this.wastes.clear();
        for (int i = 0; i < wastes.length; ++i) {
            this.wastes.add(wastes[i]);
        }
        this.getPropertyChangeHandler().firePropertyChange("wastes", null, (Object)wastes);
    }

    @Override
    public Waste getWaste(int idx) {
        return (Waste)this.wastes.get(idx);
    }

    public void setWaste(int idx, Waste waste) {
        this.wastes.set(idx, waste);
        this.getPropertyChangeHandler().firePropertyChange("wastes", null, this.wastes);
    }

    public void addWaste(IWaste waste) {
        this.wastes.add(waste);
        this.getPropertyChangeHandler().firePropertyChange("wastes", null, this.wastes);
    }

    public boolean removeWaste(Waste waste) {
        boolean ret = this.wastes.remove(waste);
        if (ret) {
            this.getPropertyChangeHandler().firePropertyChange("wastes", null, this.wastes);
        }
        return ret;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        int oldc = this.capacity;
        this.capacity = capacity;
        this.getPropertyChangeHandler().firePropertyChange("capacity", oldc, capacity);
    }

    public String toString() {
        return "Wastebin(id=" + this.getId() + ", location=" + this.getLocation() + ")";
    }

    @Override
    public boolean isFull() {
        return this.wastes.size() >= this.capacity;
    }

    public void empty() {
        this.wastes.clear();
    }

    public void fill() {
        while (!this.isFull()) {
            this.wastes.add(new Waste(new Location(-1.0, -1.0)));
        }
    }

    @Override
    public boolean contains(IWaste waste) {
        return this.wastes.contains(waste);
    }

    @Override
    public Wastebin clone() {
        Wastebin clone = (Wastebin)super.clone();
        clone.wastes = new ArrayList<IWaste>();
        for (int i = 0; i < this.wastes.size(); ++i) {
            clone.wastes.add(((Waste)this.wastes.get(i)).clone());
        }
        return clone;
    }
}

