/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.gui;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.impl.ExecutionComponentFeature;
import jadex.bridge.service.types.cms.CMSStatusEvent;
import jadex.bridge.service.types.cms.SComponentManagementService;
import jadex.commons.gui.SGUI;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SensorGui {
    private JFrame frame;
    private Timer timer;

    public SensorGui(SensorActuator sensor) {
        String id = sensor.getSelf().getId();
        IComponentIdentifier cid = sensor.getSelf().getAgentIdentifier();
        final IInternalAccess agent = (IInternalAccess)ExecutionComponentFeature.LOCAL.get();
        SwingUtilities.invokeLater(() -> {
            this.frame = new JFrame(id);
            final SensorPanel map = new SensorPanel(sensor);
            this.frame.getContentPane().add("Center", map);
            this.frame.setSize(300, 300);
            this.frame.setLocation(SGUI.calculateMiddlePosition((Window)this.frame));
            this.frame.setVisible(true);
            this.timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    map.invalidate();
                    map.repaint();
                }
            });
            this.timer.start();
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    agent.getExternalAccess().killComponent();
                }
            });
        });
        SComponentManagementService.listenToComponent((IComponentIdentifier)cid, (IInternalAccess)agent).next(cse -> {
            if (cse instanceof CMSStatusEvent.CMSTerminatedEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SensorGui.this.timer.stop();
                        SensorGui.this.frame.dispose();
                    }
                });
            }
        });
    }

    public void setVisible(boolean visible) {
        SwingUtilities.invokeLater(() -> this.frame.setVisible(visible));
    }
}

