/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.gui;

import jadex.bridge.ComponentIdentifier;
import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.ILocation;
import jadex.quickstart.cleanerworld.environment.ILocationObject;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.environment.impl.Environment;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import javax.swing.JPanel;

class SensorPanel
extends JPanel {
    private static final long serialVersionUID = 550716122862043896L;
    private SensorActuator sensor;
    private IInternalAccess agent;

    public SensorPanel(SensorActuator sensor) {
        this.sensor = sensor;
        try {
            Field fagent = sensor.getClass().getDeclaredField("agent");
            this.agent = (IInternalAccess)fagent.get(sensor);
        }
        catch (Exception e) {
            SUtil.throwUnchecked((Throwable)e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            GuiData data = this.fetchGuiData();
            Rectangle bounds = this.getBounds();
            g.setColor(data.daytime ? Color.lightGray : Color.darkGray);
            g.fillRect(0, 0, bounds.width, bounds.height);
            for (ICleaner cleaner : data.cleaners) {
                Point p = SensorPanel.onScreenLocation(cleaner.getLocation(), bounds);
                int w = (int)(cleaner.getVisionRange() * (double)bounds.width);
                int h = (int)(cleaner.getVisionRange() * (double)bounds.height);
                int n = Math.abs(cleaner.getAgentIdentifier().getParent().getLocalName().hashCode() % 8);
                g.setColor(new Color((n & 1) != 0 ? 255 : 100, (n & 2) != 0 ? 255 : 100, (n & 4) != 0 ? 255 : 100, 192));
                g.fillOval(p.x - w, p.y - h, w * 2, h * 2);
                g.setColor(new Color(50, 50, 50, 180));
                g.fillOval(p.x - 3, p.y - 3, 7, 7);
                g.drawString(cleaner.getAgentIdentifier().getLocalName(), p.x + 5, p.y - 5);
                g.drawString("battery: " + (int)(cleaner.getChargestate() * 100.0) + "%", p.x + 5, p.y + 5);
                g.drawString("waste: " + (cleaner.getCarriedWaste() != null ? "yes" : "no"), p.x + 5, p.y + 15);
            }
            Point p = SensorPanel.onScreenLocation(data.self.getLocation(), bounds);
            int w = (int)(data.self.getVisionRange() * (double)bounds.width);
            int h = (int)(data.self.getVisionRange() * (double)bounds.height);
            int colorcode = Math.abs(ComponentIdentifier.getPlatformPrefix((String)data.self.getAgentIdentifier().getParent().getLocalName()).hashCode() % 8);
            g.setColor(new Color((colorcode & 1) != 0 ? 255 : 100, (colorcode & 2) != 0 ? 255 : 100, (colorcode & 4) != 0 ? 255 : 100, 192));
            g.fillOval(p.x - w, p.y - h, w * 2, h * 2);
            g.setColor(Color.black);
            g.fillOval(p.x - 3, p.y - 3, 7, 7);
            g.drawString(data.self.getAgentIdentifier().getLocalName(), p.x + 5, p.y - 5);
            g.drawString("battery: " + (int)(data.self.getChargestate() * 100.0) + "%", p.x + 5, p.y + 5);
            g.drawString("waste: " + (data.self.getCarriedWaste() != null ? "yes" : "no"), p.x + 5, p.y + 15);
            for (IChargingstation iChargingstation : data.stations) {
                g.setColor(Color.blue);
                p = SensorPanel.onScreenLocation(iChargingstation.getLocation(), bounds);
                g.drawRect(p.x - 10, p.y - 10, 20, 20);
                g.setColor(data.daytime ? Color.black : Color.white);
                g.drawString(iChargingstation.getId(), p.x + 14, p.y + 5);
            }
            for (ILocationObject iLocationObject : data.wastebins) {
                g.setColor(Color.red);
                p = SensorPanel.onScreenLocation(iLocationObject.getLocation(), bounds);
                g.drawOval(p.x - 10, p.y - 10, 20, 20);
                g.setColor(data.daytime ? Color.black : Color.white);
                g.drawString(iLocationObject.getId() + " (" + iLocationObject.getWastes().length + "/" + iLocationObject.getCapacity() + ")", p.x + 14, p.y + 5);
            }
            for (ILocationObject iLocationObject : data.wastes) {
                g.setColor(Color.red);
                p = SensorPanel.onScreenLocation(iLocationObject.getLocation(), bounds);
                g.fillOval(p.x - 3, p.y - 3, 7, 7);
            }
            if (data.target != null) {
                g.setColor(Color.black);
                p = SensorPanel.onScreenLocation(data.target, bounds);
                g.drawOval(p.x - 5, p.y - 5, 10, 10);
                g.drawLine(p.x - 7, p.y, p.x + 7, p.y);
                g.drawLine(p.x, p.y - 7, p.x, p.y + 7);
            }
        }
        catch (ComponentTerminatedException componentTerminatedException) {
            // empty catch block
        }
    }

    private static Point onScreenLocation(ILocation loc, Rectangle bounds) {
        assert (loc != null);
        assert (bounds != null);
        return new Point((int)((double)bounds.width * loc.getX()), (int)((double)bounds.height * (1.0 - loc.getY())));
    }

    private GuiData fetchGuiData() {
        return (GuiData)this.agent.getExternalAccess().scheduleStep((IComponentStep)new IComponentStep<GuiData>(){

            public IFuture<GuiData> execute(IInternalAccess ia) {
                GuiData ret = new GuiData();
                ret.self = SensorPanel.this.sensor.getSelf();
                ret.target = SensorPanel.this.sensor.getTarget();
                ret.daytime = SensorPanel.this.sensor.isDaytime();
                ret.cleaners = (ICleaner[])Environment.cloneList(SensorPanel.this.sensor.getCleaners(), ICleaner.class);
                ret.wastes = (IWaste[])Environment.cloneList(SensorPanel.this.sensor.getWastes(), IWaste.class);
                ret.stations = (IChargingstation[])Environment.cloneList(SensorPanel.this.sensor.getChargingstations(), IChargingstation.class);
                ret.wastebins = (IWastebin[])Environment.cloneList(SensorPanel.this.sensor.getWastebins(), IWastebin.class);
                return new Future((Object)ret);
            }
        }).get();
    }

    private static class GuiData {
        public ICleaner self;
        public ILocation target;
        public boolean daytime;
        public ICleaner[] cleaners;
        public IWaste[] wastes;
        public IChargingstation[] stations;
        public IWastebin[] wastebins;

        private GuiData() {
        }
    }
}

