/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.multi.messaging;

import jadex.bdiv3.annotation.Belief;
import jadex.bdiv3.annotation.Plan;
import jadex.bdiv3.annotation.Trigger;
import jadex.bdiv3.features.IBDIAgentFeature;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IMessageFeature;
import jadex.bridge.fipa.FipaMessage;
import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.OnMessage;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;
import java.util.LinkedHashSet;
import java.util.Set;

@Agent(type="bdi")
public class SimpleMessagingCleanerAgent {
    @Belief
    private Set<ICleaner> others = new LinkedHashSet<ICleaner>();
    private SensorActuator actsense = new SensorActuator();

    @OnStart
    private void exampleBehavior(IBDIAgentFeature bdifeature) {
        this.actsense.manageCleanersIn(this.others);
        new SensorGui(this.actsense).setVisible(true);
        while (true) {
            this.actsense.moveTo(Math.random(), Math.random());
        }
    }

    @Plan(trigger=@Trigger(factadded={"others"}))
    public void cleanerAdded(ICleaner other, IInternalAccess agent) {
        System.out.println("Agent " + agent + " sending message to: " + other);
        String performative = "inform";
        Set<IWaste> content = this.actsense.getWastes();
        FipaMessage message = new FipaMessage(performative, content, new IComponentIdentifier[0]);
        message.addReceiver(other.getAgentIdentifier());
        ((IMessageFeature)agent.getFeature(IMessageFeature.class)).sendMessage((Object)message, new IComponentIdentifier[0]).get();
    }

    @OnMessage
    void messageArrived(FipaMessage message) {
        IComponentIdentifier sender = message.getSender();
        String performative = message.getPerformative();
        Object content = message.getContent();
        System.out.println("Agent received message: " + performative + "(" + content + ") from " + sender);
    }
}

