/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.single;

import jadex.bdiv3.annotation.Belief;
import jadex.bdiv3.annotation.Deliberation;
import jadex.bdiv3.annotation.Goal;
import jadex.bdiv3.annotation.GoalMaintainCondition;
import jadex.bdiv3.annotation.Plan;
import jadex.bdiv3.annotation.Trigger;
import jadex.bdiv3.features.IBDIAgentFeature;
import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;

@Agent(type="bdi")
public class CleanerBDIAgentB2 {
    private SensorActuator actsense = new SensorActuator();
    @Belief
    private ICleaner self = this.actsense.getSelf();

    @OnStart
    private void exampleBehavior(IBDIAgentFeature bdi) {
        new SensorGui(this.actsense).setVisible(true);
        bdi.dispatchTopLevelGoal((Object)new PerformPatrol());
        bdi.dispatchTopLevelGoal((Object)new MaintainBatteryLoaded());
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan() {
        System.out.println("Starting performPatrolPlan()");
        this.actsense.moveTo(0.1, 0.1);
        this.actsense.moveTo(0.1, 0.9);
        this.actsense.moveTo(0.9, 0.9);
        this.actsense.moveTo(0.9, 0.1);
        this.actsense.moveTo(0.1, 0.1);
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan2() {
        System.out.println("Starting performPatrolPlan2()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan3() {
        System.out.println("Starting performPatrolPlan3()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={MaintainBatteryLoaded.class}))
    private void loadBattery() {
        System.out.println("Starting loadBattery() plan");
        IChargingstation chargingstation = this.actsense.getChargingstations().iterator().next();
        this.actsense.moveTo(chargingstation.getLocation());
        this.actsense.recharge(chargingstation, 1.0);
    }

    @Goal(recur=true, recurdelay=3000L, deliberation=@Deliberation(inhibits={PerformPatrol.class}))
    class MaintainBatteryLoaded {
        MaintainBatteryLoaded() {
        }

        @GoalMaintainCondition
        boolean isBatteryLoaded() {
            return CleanerBDIAgentB2.this.self.getChargestate() >= 0.2;
        }
    }

    @Goal(recur=true, orsuccess=false, recurdelay=3000L)
    class PerformPatrol {
        PerformPatrol() {
        }
    }
}

