/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.single;

import jadex.bdiv3.annotation.Belief;
import jadex.bdiv3.annotation.Deliberation;
import jadex.bdiv3.annotation.ExcludeMode;
import jadex.bdiv3.annotation.Goal;
import jadex.bdiv3.annotation.GoalMaintainCondition;
import jadex.bdiv3.annotation.GoalTargetCondition;
import jadex.bdiv3.annotation.Plan;
import jadex.bdiv3.annotation.Trigger;
import jadex.bdiv3.features.IBDIAgentFeature;
import jadex.bdiv3.runtime.IPlan;
import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;
import java.util.LinkedHashSet;
import java.util.Set;

@Agent(type="bdi")
public class CleanerBDIAgentC2 {
    private SensorActuator actsense = new SensorActuator();
    @Belief
    private ICleaner self = this.actsense.getSelf();
    @Belief
    private Set<IChargingstation> stations = new LinkedHashSet<IChargingstation>();

    @OnStart
    private void exampleBehavior(IBDIAgentFeature bdi) {
        this.actsense.manageChargingstationsIn(this.stations);
        new SensorGui(this.actsense).setVisible(true);
        bdi.dispatchTopLevelGoal((Object)new PerformPatrol());
        bdi.dispatchTopLevelGoal((Object)new MaintainBatteryLoaded());
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan2() {
        System.out.println("Starting performPatrolPlan2()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan3() {
        System.out.println("Starting performPatrolPlan3()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={MaintainBatteryLoaded.class}))
    private void loadBattery(IPlan plan) {
        System.out.println("Starting loadBattery() plan");
        QueryChargingStation querygoal = new QueryChargingStation();
        plan.dispatchSubgoal((Object)querygoal).get();
        IChargingstation chargingstation = querygoal.station;
        this.actsense.moveTo(chargingstation.getLocation());
        this.actsense.recharge(chargingstation, 1.0);
    }

    @Plan(trigger=@Trigger(goals={QueryChargingStation.class}))
    private void moveAround() {
        System.out.println("Starting moveAround() plan");
        this.actsense.moveTo(Math.random(), Math.random());
    }

    @Goal(excludemode=ExcludeMode.Never)
    class QueryChargingStation {
        IChargingstation station;

        QueryChargingStation() {
        }

        @GoalTargetCondition
        boolean isStationKnown() {
            this.station = CleanerBDIAgentC2.this.stations.isEmpty() ? null : CleanerBDIAgentC2.this.stations.iterator().next();
            return this.station != null;
        }
    }

    @Goal(recur=true, recurdelay=3000L, deliberation=@Deliberation(inhibits={PerformPatrol.class}))
    class MaintainBatteryLoaded {
        MaintainBatteryLoaded() {
        }

        @GoalMaintainCondition
        boolean isBatteryLoaded() {
            return CleanerBDIAgentC2.this.self.getChargestate() >= 0.4;
        }

        @GoalTargetCondition
        boolean isBatteryFullyLoaded() {
            return CleanerBDIAgentC2.this.self.getChargestate() >= 0.9;
        }
    }

    @Goal(recur=true, orsuccess=false, recurdelay=3000L)
    class PerformPatrol {
        PerformPatrol() {
        }
    }
}

