/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.single;

import jadex.bdiv3.annotation.Belief;
import jadex.bdiv3.annotation.Deliberation;
import jadex.bdiv3.annotation.ExcludeMode;
import jadex.bdiv3.annotation.Goal;
import jadex.bdiv3.annotation.GoalContextCondition;
import jadex.bdiv3.annotation.GoalCreationCondition;
import jadex.bdiv3.annotation.GoalMaintainCondition;
import jadex.bdiv3.annotation.GoalTargetCondition;
import jadex.bdiv3.annotation.Plan;
import jadex.bdiv3.annotation.Trigger;
import jadex.bdiv3.features.IBDIAgentFeature;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.IPlan;
import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;
import java.util.LinkedHashSet;
import java.util.Set;

@Agent(type="bdi")
public class CleanerBDIAgentD3b {
    private SensorActuator actsense = new SensorActuator();
    @Belief
    private ICleaner self = this.actsense.getSelf();
    @Belief
    private Set<IChargingstation> stations = new LinkedHashSet<IChargingstation>();
    @Belief
    private Set<IWastebin> wastebins = new LinkedHashSet<IWastebin>();
    @Belief
    private Set<IWaste> wastes = new LinkedHashSet<IWaste>();

    @OnStart
    private void exampleBehavior(IBDIAgentFeature bdi) {
        this.actsense.manageChargingstationsIn(this.stations);
        this.actsense.manageWastesIn(this.wastes);
        this.actsense.manageWastebinsIn(this.wastebins);
        new SensorGui(this.actsense).setVisible(true);
        bdi.dispatchTopLevelGoal((Object)new PerformPatrol());
        bdi.dispatchTopLevelGoal((Object)new MaintainBatteryLoaded());
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan2() {
        System.out.println("Starting performPatrolPlan2()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={PerformPatrol.class}))
    private void performPatrolPlan3() {
        System.out.println("Starting performPatrolPlan3()");
        this.actsense.moveTo(0.3, 0.3);
        this.actsense.moveTo(0.7, 0.7);
        this.actsense.moveTo(0.3, 0.7);
        this.actsense.moveTo(0.7, 0.3);
        this.actsense.moveTo(0.3, 0.3);
    }

    @Plan(trigger=@Trigger(goals={MaintainBatteryLoaded.class}))
    private void loadBattery(IPlan plan) {
        System.out.println("Starting loadBattery() plan");
        QueryChargingStation querygoal = new QueryChargingStation();
        plan.dispatchSubgoal((Object)querygoal).get();
        IChargingstation chargingstation = querygoal.station;
        this.actsense.moveTo(chargingstation.getLocation());
        this.actsense.recharge(chargingstation, 1.0);
    }

    @Plan(trigger=@Trigger(goals={QueryChargingStation.class, QueryWastebin.class}))
    private void moveAround(IPlan plan) {
        System.out.println("Starting moveAround() plan for goal " + plan.getReason());
        this.actsense.moveTo(Math.random(), Math.random());
    }

    @Plan(trigger=@Trigger(goalfinisheds={AchieveCleanupWaste.class}))
    private void finishedCleanup(IGoal goal, AchieveCleanupWaste cleanup) {
        String state = goal.getProcessingState().toString();
        System.out.println("finished goal with state " + state + " for " + cleanup.waste);
    }

    @Plan(trigger=@Trigger(goals={AchieveCleanupWaste.class}))
    private void cleanupWaste(IPlan plan, AchieveCleanupWaste cleanup) {
        System.out.println("Starting cleanupWaste() plan");
        if (!cleanup.waste.equals(this.self.getCarriedWaste())) {
            this.actsense.moveTo(cleanup.waste.getLocation());
            this.actsense.pickUpWaste(cleanup.waste);
        }
        QueryWastebin querygoal = new QueryWastebin();
        plan.dispatchSubgoal((Object)querygoal).get();
        IWastebin wastebin = querygoal.wastebin;
        this.actsense.moveTo(wastebin.getLocation());
        this.actsense.dropWasteInWastebin(cleanup.waste, wastebin);
    }

    @Goal(recur=true, recurdelay=3000L, deliberation=@Deliberation(inhibits={PerformPatrol.class}, cardinalityone=true))
    class AchieveCleanupWaste {
        IWaste waste;

        @GoalCreationCondition(factadded={"wastes"})
        public AchieveCleanupWaste(IWaste waste) {
            System.out.println("Created achieve cleanup goal for " + waste);
            this.waste = waste;
        }

        @GoalTargetCondition
        boolean isClean() {
            return !CleanerBDIAgentD3b.this.wastes.contains(this.waste) && !this.waste.equals(CleanerBDIAgentD3b.this.self.getCarriedWaste());
        }

        @GoalContextCondition
        boolean isPossible() {
            return CleanerBDIAgentD3b.this.self.getCarriedWaste() == null || CleanerBDIAgentD3b.this.self.getCarriedWaste().equals(this.waste);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.waste + ")";
        }
    }

    @Goal(excludemode=ExcludeMode.Never)
    class QueryWastebin {
        IWastebin wastebin;

        QueryWastebin() {
        }

        @GoalTargetCondition
        boolean isWastebinKnown() {
            this.wastebin = CleanerBDIAgentD3b.this.wastebins.isEmpty() ? null : CleanerBDIAgentD3b.this.wastebins.iterator().next();
            return this.wastebin != null;
        }
    }

    @Goal(excludemode=ExcludeMode.Never)
    class QueryChargingStation {
        IChargingstation station;

        QueryChargingStation() {
        }

        @GoalTargetCondition
        boolean isStationKnown() {
            this.station = CleanerBDIAgentD3b.this.stations.isEmpty() ? null : CleanerBDIAgentD3b.this.stations.iterator().next();
            return this.station != null;
        }
    }

    @Goal(recur=true, recurdelay=3000L, deliberation=@Deliberation(inhibits={PerformPatrol.class, AchieveCleanupWaste.class}))
    class MaintainBatteryLoaded {
        MaintainBatteryLoaded() {
        }

        @GoalMaintainCondition
        boolean isBatteryLoaded() {
            return CleanerBDIAgentD3b.this.self.getChargestate() >= 0.4;
        }

        @GoalTargetCondition
        boolean isBatteryFullyLoaded() {
            return CleanerBDIAgentD3b.this.self.getChargestate() >= 0.9;
        }
    }

    @Goal(recur=true, orsuccess=false, recurdelay=3000L)
    class PerformPatrol {
        PerformPatrol() {
        }
    }
}

