/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.single;

import jadex.bdiv3.annotation.Belief;
import jadex.bdiv3.annotation.Deliberation;
import jadex.bdiv3.annotation.ExcludeMode;
import jadex.bdiv3.annotation.Goal;
import jadex.bdiv3.annotation.GoalContextCondition;
import jadex.bdiv3.annotation.GoalCreationCondition;
import jadex.bdiv3.annotation.GoalInhibit;
import jadex.bdiv3.annotation.GoalResult;
import jadex.bdiv3.annotation.GoalTargetCondition;
import jadex.bdiv3.annotation.Plan;
import jadex.bdiv3.annotation.PlanBody;
import jadex.bdiv3.annotation.Trigger;
import jadex.bdiv3.features.IBDIAgentFeature;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.ICleaner;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;
import java.util.LinkedHashSet;
import java.util.Set;

@Agent(type="bdi")
public class CleanerBDIAgentFinal {
    @Belief
    private Set<IWaste> wastes = new LinkedHashSet<IWaste>();
    @Belief
    private Set<IWastebin> wastebins = new LinkedHashSet<IWastebin>();
    @Belief
    private Set<IChargingstation> stations = new LinkedHashSet<IChargingstation>();
    @Belief
    private Set<ICleaner> others = new LinkedHashSet<ICleaner>();
    private SensorActuator actsense = new SensorActuator();
    @Belief
    private ICleaner self = this.actsense.getSelf();
    @Belief(updaterate=1000L)
    private boolean daytime = this.actsense.isDaytime();
    @AgentArgument
    private boolean sensorgui = true;

    @OnStart
    private void exampleBehavior(IBDIAgentFeature bdifeature) {
        this.actsense.manageWastesIn(this.wastes);
        this.actsense.manageWastebinsIn(this.wastebins);
        this.actsense.manageChargingstationsIn(this.stations);
        this.actsense.manageCleanersIn(this.others);
        if (this.sensorgui) {
            new SensorGui(this.actsense).setVisible(true);
        }
        bdifeature.dispatchTopLevelGoal((Object)new PerformLookForWaste());
    }

    @Plan(trigger=@Trigger(goals={AchieveCleanupWaste.class}))
    private void achieveCleanupPlan(AchieveCleanupWaste goal, IInternalAccess bdifeature) {
        System.out.println("Moving to: " + goal.waste);
        this.actsense.moveTo(goal.waste.getLocation().getX(), goal.waste.getLocation().getY());
        System.out.println("Pickung up: " + goal.waste);
        this.actsense.pickUpWaste(goal.waste);
        System.out.println("Querying waste bin: " + goal.waste);
        IWastebin wastebin = (IWastebin)((IBDIAgentFeature)bdifeature.getFeature(IBDIAgentFeature.class)).dispatchTopLevelGoal((Object)new QueryWastebin()).get();
        System.out.println("Moving to waste bin: " + goal.waste + ", " + wastebin);
        this.actsense.moveTo(wastebin.getLocation().getX(), wastebin.getLocation().getY());
        System.out.println("Dropping in waste bin: " + goal.waste + ", " + wastebin);
        this.actsense.dropWasteInWastebin(goal.waste, wastebin);
        System.out.println("Dropped in waste bin: " + goal.waste + ", " + wastebin);
    }

    @Goal(excludemode=ExcludeMode.Never)
    private class QueryWastebin {
        @GoalResult
        protected IWastebin wastebin;

        private QueryWastebin() {
        }

        @GoalTargetCondition(beliefs={"wastebins"})
        public boolean checkTarget() {
            for (IWastebin wb : CleanerBDIAgentFinal.this.wastebins) {
                if (wb.isFull()) continue;
                if (this.wastebin == null) {
                    this.wastebin = wb;
                    continue;
                }
                if (!(CleanerBDIAgentFinal.this.self.getLocation().getDistance(wb.getLocation()) < CleanerBDIAgentFinal.this.self.getLocation().getDistance(this.wastebin.getLocation()))) continue;
                this.wastebin = wb;
            }
            return this.wastebin != null;
        }
    }

    @Goal(deliberation=@Deliberation(inhibits={PerformLookForWaste.class, AchieveCleanupWaste.class}), unique=true)
    class AchieveCleanupWaste {
        private IWaste waste;

        @GoalCreationCondition(beliefs={"wastes"})
        AchieveCleanupWaste(IWaste waste) {
            System.out.println("achieve cleanup: " + waste);
            this.waste = waste;
        }

        public boolean equals(Object obj) {
            return obj instanceof AchieveCleanupWaste && ((AchieveCleanupWaste)obj).waste.equals(this.waste);
        }

        public int hashCode() {
            return 31 + this.waste.hashCode();
        }

        @GoalInhibit(value=AchieveCleanupWaste.class)
        private boolean inhibitOther(AchieveCleanupWaste other) {
            return this.waste.equals(CleanerBDIAgentFinal.this.self.getCarriedWaste()) || !other.waste.equals(CleanerBDIAgentFinal.this.self.getCarriedWaste()) && this.waste.getLocation().getDistance(CleanerBDIAgentFinal.this.self.getLocation()) < other.waste.getLocation().getDistance(CleanerBDIAgentFinal.this.self.getLocation());
        }
    }

    @Plan(trigger=@Trigger(goals={PerformLookForWaste.class, QueryWastebin.class}))
    private class moveAround {
        private moveAround() {
        }

        @PlanBody
        private void doMoveAround() {
            CleanerBDIAgentFinal.this.actsense.moveTo(Math.random(), Math.random());
        }
    }

    @Goal(excludemode=ExcludeMode.Never, orsuccess=false)
    private class PerformLookForWaste {
        private PerformLookForWaste() {
        }

        @GoalContextCondition
        private boolean context() {
            return CleanerBDIAgentFinal.this.daytime;
        }
    }
}

