/*
 * Decompiled with CFR 0.152.
 */
package jadex.quickstart.cleanerworld.single;

import jadex.bridge.service.annotation.OnStart;
import jadex.micro.annotation.Agent;
import jadex.quickstart.cleanerworld.environment.IChargingstation;
import jadex.quickstart.cleanerworld.environment.IWaste;
import jadex.quickstart.cleanerworld.environment.IWastebin;
import jadex.quickstart.cleanerworld.environment.SensorActuator;
import jadex.quickstart.cleanerworld.gui.SensorGui;

@Agent
public class SimpleCleanerAgentZero {
    @OnStart
    private void exampleBehavior() {
        SensorActuator actsense = new SensorActuator();
        new SensorGui(actsense).setVisible(true);
        while (true) {
            if (actsense.getSelf().getChargestate() < 0.2) {
                if (!actsense.getChargingstations().isEmpty()) {
                    IChargingstation station = actsense.getChargingstations().iterator().next();
                    actsense.moveTo(station.getLocation());
                    actsense.recharge(station, 0.9);
                    continue;
                }
                actsense.moveTo(Math.random(), Math.random());
                continue;
            }
            if (actsense.getSelf().getCarriedWaste() != null) {
                if (!actsense.getWastebins().isEmpty()) {
                    IWastebin bin = actsense.getWastebins().iterator().next();
                    actsense.moveTo(bin.getLocation());
                    actsense.dropWasteInWastebin(actsense.getSelf().getCarriedWaste(), bin);
                    continue;
                }
                actsense.moveTo(Math.random(), Math.random());
                continue;
            }
            if (!actsense.getWastes().isEmpty()) {
                IWaste waste = actsense.getWastes().iterator().next();
                actsense.moveTo(waste.getLocation());
                actsense.pickUpWaste(waste);
                continue;
            }
            actsense.moveTo(Math.random(), Math.random());
        }
    }
}

