/*
 * Decompiled with CFR 0.152.
 */
package jadex.application;

import jadex.application.ApplicationModelLoader;
import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.service.BasicService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.factory.IComponentFactory;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.bridge.service.types.library.ILibraryServiceListener;
import jadex.commons.LazyResource;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.kernelbase.IBootstrapFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ApplicationComponentFactory
extends BasicService
implements IComponentFactory,
IBootstrapFactory {
    public static final String[] FILETYPES = new String[]{".application.xml"};
    public static final String FILETYPE_APPLICATION = "Application";
    protected static final LazyResource ICON = new LazyResource(ApplicationComponentFactory.class, "/jadex/application/images/application.png");
    protected ApplicationModelLoader loader;
    protected IInternalAccess provider;
    protected ILibraryService libservice;
    protected ILibraryServiceListener libservicelistener;
    protected Collection<IComponentFeatureFactory> features;

    public ApplicationComponentFactory(String providerid) {
        super((IComponentIdentifier)new BasicComponentIdentifier(providerid), IComponentFactory.class, null);
        String[] extensions = new String[]{"jadex.extension.envsupport.MEnvSpaceType", "getXMLMapping", "jadex.extension.agr.AGRExtensionService", "getXMLMapping"};
        ArrayList<Set> mappings = new ArrayList<Set>();
        for (int i = 0; i < extensions.length; i += 2) {
            try {
                Class<?> clazz = Class.forName(extensions[i], true, ((Object)((Object)this)).getClass().getClassLoader());
                Method m = clazz.getMethod(extensions[i + 1], new Class[0]);
                mappings.add((Set)m.invoke(null, new Object[0]));
                continue;
            }
            catch (ClassNotFoundException clazz) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loader = new ApplicationModelLoader(mappings.toArray(new Set[0]));
        this.features = SComponentFactory.DEFAULT_FEATURES;
    }

    public ApplicationComponentFactory(IInternalAccess provider) {
        super(provider.getComponentIdentifier(), IComponentFactory.class, null);
        this.provider = provider;
        this.features = SComponentFactory.DEFAULT_FEATURES;
    }

    public IFuture<Void> startService(IInternalAccess component, IResourceIdentifier rid) {
        this.provider = component;
        this.providerid = this.provider.getComponentIdentifier();
        this.createServiceIdentifier("BootstrapFactory", IComponentFactory.class, rid, IComponentFactory.class, null);
        return this.startService();
    }

    public IFuture<Void> startService() {
        final Future ret = new Future();
        super.startService().addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                SServiceProvider.getService((IInternalAccess)ApplicationComponentFactory.this.provider, ILibraryService.class, (String)"platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<ILibraryService, Void>(ret){

                    public void customResultAvailable(ILibraryService result) {
                        ApplicationComponentFactory.this.libservice = result;
                        String[] extensions = new String[]{"jadex.extension.envsupport.MEnvSpaceType", "getXMLMapping", "jadex.extension.agr.AGRExtensionService", "getXMLMapping"};
                        ArrayList<Set> mappings = new ArrayList<Set>();
                        for (int i = 0; i < extensions.length; i += 2) {
                            try {
                                Class<?> clazz = Class.forName(extensions[i], true, ((Object)((Object)this)).getClass().getClassLoader());
                                Method m = clazz.getMethod(extensions[i + 1], new Class[0]);
                                mappings.add((Set)m.invoke(null, new Object[0]));
                                continue;
                            }
                            catch (ClassNotFoundException clazz) {
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ApplicationComponentFactory.this.loader = new ApplicationModelLoader(mappings.toArray(new Set[0]));
                        ApplicationComponentFactory.this.libservicelistener = new ILibraryServiceListener(){

                            public IFuture<Void> resourceIdentifierRemoved(IResourceIdentifier parid, IResourceIdentifier rid) {
                                ApplicationComponentFactory.this.loader.clearModelCache();
                                return IFuture.DONE;
                            }

                            public IFuture<Void> resourceIdentifierAdded(IResourceIdentifier parid, IResourceIdentifier rid, boolean rem) {
                                ApplicationComponentFactory.this.loader.clearModelCache();
                                return IFuture.DONE;
                            }
                        };
                        ApplicationComponentFactory.this.libservice.addLibraryServiceListener(ApplicationComponentFactory.this.libservicelistener);
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> shutdownService() {
        final Future ret = new Future();
        this.libservice.removeLibraryServiceListener(this.libservicelistener).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                ApplicationComponentFactory.super.shutdownService().addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }

    public IFuture<IModelInfo> loadModel(final String model, final String[] imports, final IResourceIdentifier rid) {
        final Future ret = new Future();
        if (this.libservice != null) {
            this.libservice.getClassLoader(rid).addResultListener((IResultListener)new ExceptionDelegationResultListener<ClassLoader, IModelInfo>(ret){

                public void customResultAvailable(ClassLoader cl) {
                    try {
                        ret.setResult((Object)ApplicationComponentFactory.this.loader.loadApplicationModel(model, imports, rid, cl, new Object[]{rid, ApplicationComponentFactory.this.getProviderId().getRoot()}).getModelInfo());
                    }
                    catch (Exception e) {
                        ret.setException(e);
                    }
                }
            });
        } else {
            try {
                ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                ret.setResult((Object)this.loader.loadApplicationModel(model, imports, rid, cl, new Object[]{rid, this.getProviderId().getRoot()}).getModelInfo());
            }
            catch (Exception e) {
                ret.setException(e);
            }
        }
        return ret;
    }

    public IFuture<Boolean> isLoadable(String model, String[] imports, IResourceIdentifier rid) {
        return new Future((Object)model.endsWith(".application.xml"));
    }

    public IFuture<Boolean> isStartable(String model, String[] imports, IResourceIdentifier rid) {
        return new Future((Object)model.endsWith(".application.xml"));
    }

    public String[] getComponentTypes() {
        return new String[]{FILETYPE_APPLICATION};
    }

    public IFuture<byte[]> getComponentTypeIcon(String type) {
        Future ret = new Future();
        if (type.equals(FILETYPE_APPLICATION)) {
            try {
                ret.setResult((Object)ICON.getData());
            }
            catch (IOException e) {
                ret.setException((Exception)e);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<String> getComponentType(String model, String[] imports, IResourceIdentifier rid) {
        return new Future((Object)(model.toLowerCase().endsWith(".application.xml") ? FILETYPE_APPLICATION : null));
    }

    public Map<String, Object> getProperties(String type) {
        if (FILETYPE_APPLICATION.equals(type)) {
            return Collections.emptyMap();
        }
        return null;
    }

    public IFuture<Collection<IComponentFeatureFactory>> getComponentFeatures(IModelInfo model) {
        return new Future(this.features);
    }
}

