/*
 * Decompiled with CFR 0.152.
 */
package jadex.application;

import jadex.application.ApplicationConfigurationInfo;
import jadex.application.ApplicationModelInfo;
import jadex.application.EnvironmentService;
import jadex.application.IEnvironmentService;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.ProvidedServiceImplementation;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.component.ComponentXMLReader;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeConverter;
import jadex.xml.AttributeInfo;
import jadex.xml.IAttributeConverter;
import jadex.xml.IContext;
import jadex.xml.IPostProcessor;
import jadex.xml.MappingInfo;
import jadex.xml.ObjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.XMLInfo;
import jadex.xml.stax.QName;
import java.util.Iterator;
import java.util.Set;

public class ApplicationXMLReader
extends ComponentXMLReader {
    public ApplicationXMLReader(Set<TypeInfo>[] mappings) {
        super(ApplicationXMLReader.getXMLMapping(mappings, "http://www.activecomponents.org/jadex-application"));
    }

    protected String getModelType(String filename) {
        return "Application";
    }

    public static Set<TypeInfo> getXMLMapping(Set<TypeInfo>[] mappings, String uri) {
        Set types = ComponentXMLReader.getXMLMapping((Set[])mappings, (String)uri);
        TypeInfo comptype = null;
        TypeInfo configtype = null;
        Iterator it = types.iterator();
        while ((configtype == null || comptype == null) && it.hasNext()) {
            TypeInfo ti = (TypeInfo)it.next();
            if (comptype == null && ti.getXMLInfo().getXMLPath().equals(new XMLInfo(new QName(uri, "componenttype")).getXMLPath())) {
                comptype = ti;
            }
            if (configtype != null || !ti.getXMLInfo().getXMLPath().equals(new XMLInfo(new QName(uri, "configuration")).getXMLPath())) continue;
            configtype = ti;
            it.remove();
        }
        IPostProcessor appproc = new IPostProcessor(){

            public Object postProcess(IContext context, Object object) {
                ApplicationModelInfo mi = (ApplicationModelInfo)((Object)object);
                if (mi.getExtensionTypes().length > 0) {
                    boolean found = false;
                    for (ProvidedServiceInfo pi : mi.getProvidedServices()) {
                        if (!IEnvironmentService.class.equals((Object)pi.getType().getType(context.getClassLoader(), mi.getAllImports()))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        mi.addProvidedService(new ProvidedServiceInfo(null, IEnvironmentService.class, new ProvidedServiceImplementation(EnvironmentService.class, null, null, null, null), null, null, null));
                    }
                }
                return null;
            }

            public int getPass() {
                return 1;
            }
        };
        types.add(new TypeInfo(new XMLInfo(new QName(uri, "applicationtype")), new ObjectInfo(ApplicationModelInfo.class, appproc), new MappingInfo(comptype)));
        types.add(new TypeInfo(new XMLInfo(new QName(uri, "application")), new ObjectInfo(ApplicationConfigurationInfo.class), new MappingInfo(configtype)));
        types.add(new TypeInfo(new XMLInfo(new QName(uri, "configuration")), new ObjectInfo(ApplicationConfigurationInfo.class), new MappingInfo(configtype)));
        types.add(new TypeInfo(new XMLInfo(new QName[]{new QName(uri, "applicationtype"), new QName(uri, "arguments"), new QName(uri, "argument")}), new ObjectInfo(Argument.class, (IPostProcessor)new ComponentXMLReader.ExpressionProcessor()), new MappingInfo(null, (Object)"description", (Object)"value", new AttributeInfo[]{new AttributeInfo(new AccessInfo("class", (Object)"clazz"), (IAttributeConverter)new AttributeConverter(classconv, reclassconv))}, null)));
        types.add(new TypeInfo(new XMLInfo(new QName[]{new QName(uri, "applicationtype"), new QName(uri, "arguments"), new QName(uri, "result")}), new ObjectInfo(Argument.class, (IPostProcessor)new ComponentXMLReader.ExpressionProcessor()), new MappingInfo(null, (Object)"description", (Object)"value", new AttributeInfo[]{new AttributeInfo(new AccessInfo("class", (Object)"clazz"), (IAttributeConverter)new AttributeConverter(classconv, reclassconv))}, null)));
        types.add(new TypeInfo(new XMLInfo(new QName[]{new QName(uri, "application"), new QName(uri, "arguments"), new QName(uri, "argument")}), new ObjectInfo(UnparsedExpression.class), new MappingInfo(null, null, (Object)"value", new AttributeInfo[]{new AttributeInfo(new AccessInfo("class", (Object)"clazz"), (IAttributeConverter)new AttributeConverter(classconv, reclassconv))}, null)));
        return types;
    }
}

