/*
 * Decompiled with CFR 0.152.
 */
package jadex.application;

import jadex.application.ApplicationConfigurationInfo;
import jadex.application.IEnvironmentService;
import jadex.application.IExtensionInfo;
import jadex.application.IExtensionInstance;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Reference;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceShutdown;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import java.util.LinkedHashMap;
import java.util.Map;

@Service
public class EnvironmentService
implements IEnvironmentService {
    @ServiceComponent
    protected IInternalAccess component;
    protected Map<String, IExtensionInstance> spaces;

    @ServiceStart
    public IFuture<Void> initSpaces() {
        Future ret = new Future();
        this.spaces = new LinkedHashMap<String, IExtensionInstance>();
        ApplicationConfigurationInfo config = (ApplicationConfigurationInfo)this.component.getModel().getConfiguration(this.component.getConfiguration());
        IExtensionInfo[] infos = config.getExtensions();
        CounterResultListener lis = new CounterResultListener(infos.length, (IResultListener)new DelegationResultListener(ret));
        for (final IExtensionInfo ei : infos) {
            ei.createInstance(this.component.getExternalAccess(), this.component.getFetcher()).addResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IExtensionInstance>((IResultListener)lis){
                final /* synthetic */ IResultListener val$lis;
                {
                    this.val$lis = iResultListener;
                }

                public void resultAvailable(IExtensionInstance instance) {
                    EnvironmentService.this.spaces.put(ei.getName(), instance);
                    instance.init().addResultListener(((IExecutionFeature)EnvironmentService.this.component.getComponentFeature(IExecutionFeature.class)).createResultListener(this.val$lis));
                }

                public void exceptionOccurred(Exception exception) {
                    this.val$lis.exceptionOccurred(exception);
                }
            }));
        }
        return ret;
    }

    @ServiceShutdown
    public IFuture<Void> terminateSpaces() {
        Future ret = new Future();
        CounterResultListener lis = new CounterResultListener(this.spaces.size(), (IResultListener)new DelegationResultListener(ret));
        for (IExtensionInstance instance : this.spaces.values()) {
            instance.terminate().addResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>((IResultListener)lis){
                final /* synthetic */ IResultListener val$lis;
                {
                    this.val$lis = iResultListener;
                }

                public void resultAvailable(Void result) {
                    this.val$lis.resultAvailable(null);
                }

                public void exceptionOccurred(Exception exception) {
                    this.val$lis.exceptionOccurred(exception);
                }
            }));
        }
        return ret;
    }

    @Override
    @Reference(remote=false)
    public IFuture<Object> getSpace(String name) {
        return new Future((Object)this.spaces.get(name));
    }

    public static IFuture<Object> getSpace(IInternalAccess component, final String name) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)component.getComponentFeature(IRequiredServicesFeature.class)).searchService(IEnvironmentService.class, "application").addResultListener((IResultListener)new ExceptionDelegationResultListener<IEnvironmentService, Object>(ret){

            public void customResultAvailable(IEnvironmentService es) {
                es.getSpace(name).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }
}

