/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.OnEnd;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.search.ServiceQuery;
import jadex.commons.Tuple2;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.publish.AbstractRestPublishService;
import jadex.extension.rs.publish.JettyWebsocketServer;
import jadex.extension.rs.publish.PathManager;
import jadex.extension.rs.publish.UniversalClasspathResource;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

@Service
public class JettyRestPublishService
extends AbstractRestPublishService {
    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    protected Map<IServiceIdentifier, Server> sidservers;
    protected Map<Integer, Server> portservers;
    protected Map<IServiceIdentifier, Tuple2<Server, ContextHandler>> unpublishinfos = new HashMap<IServiceIdentifier, Tuple2<Server, ContextHandler>>();

    @OnEnd
    public void stop() {
        if (this.portservers != null) {
            for (Map.Entry<Integer, Server> entry : this.portservers.entrySet()) {
                try {
                    entry.getValue().stop();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("Jetty stopped");
    }

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public IFuture<Void> publishService(final IServiceIdentifier serviceid, final PublishInfo info) {
        final Future ret = new Future();
        IFuture fut = this.evaluateMapping(serviceid, info);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<PathManager<AbstractRestPublishService.MappingInfo>, Void>(ret){

            public void customResultAvailable(final PathManager<AbstractRestPublishService.MappingInfo> pm) {
                try {
                    URI uri = new URI(JettyRestPublishService.this.getCleanPublishId(info.getPublishId()));
                    Server server = (Server)JettyRestPublishService.this.getHttpServer(uri, info);
                    System.out.println("Adding http handler to server (jetty): " + uri.getPath());
                    HandlerCollection collhandler = (HandlerCollection)server.getHandler();
                    ContextHandler ch = new ContextHandler(){
                        protected IService service = null;

                        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                            if (this.service == null) {
                                this.service = (IService)JettyRestPublishService.this.component.getExternalAccess().searchService(new ServiceQuery((Class)null).setServiceIdentifier(serviceid)).get();
                            }
                            if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
                                baseRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)MULTI_PART_CONFIG);
                            }
                            JettyRestPublishService.this.handleRequest(this.service, pm, request, response, new Object[]{target, baseRequest});
                            baseRequest.setHandled(true);
                        }
                    };
                    ch.setContextPath(uri.getPath());
                    collhandler.addHandler((Handler)ch);
                    JettyRestPublishService.this.unpublishinfos.put(serviceid, (Tuple2<Server, ContextHandler>)new Tuple2((Object)server, (Object)ch));
                    ch.start();
                    if (JettyRestPublishService.this.sidservers == null) {
                        JettyRestPublishService.this.sidservers = new HashMap<IServiceIdentifier, Server>();
                    }
                    JettyRestPublishService.this.sidservers.put(serviceid, server);
                    ret.setResult(null);
                }
                catch (Exception e) {
                    ret.setException(e);
                }
            }
        });
        return ret;
    }

    public Object getHttpServer(URI uri, PublishInfo info) {
        Server server = null;
        try {
            Server server2 = server = this.portservers == null ? null : this.portservers.get(uri.getPort());
            if (server == null) {
                System.out.println("Starting new server: " + uri.getPort());
                server = new Server(uri.getPort());
                HandlerCollection collhandler = new HandlerCollection(new Handler[]{new SessionHandler()});
                ServletContextHandler ch = new ServletContextHandler(1);
                ch.setContextPath("/wswebapi");
                ch.setAllowNullPathInfo(true);
                final WebSocketCreator wsc = new WebSocketCreator(){

                    public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
                        return new JettyWebsocketServer(JettyRestPublishService.this.component);
                    }
                };
                WebSocketHandler wsh = new WebSocketHandler(){

                    public void configure(WebSocketServletFactory factory) {
                        factory.setCreator(wsc);
                    }
                };
                ch.setHandler((Handler)wsh);
                collhandler.addHandler((Handler)ch);
                server.setHandler((Handler)collhandler);
                server.start();
                if (this.portservers == null) {
                    this.portservers = new HashMap<Integer, Server>();
                }
                this.portservers.put(uri.getPort(), server);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        Tuple2<Server, ContextHandler> unpublish = this.unpublishinfos.remove(sid);
        if (unpublish != null) {
            ((ContextHandlerCollection)((Server)unpublish.getFirstEntity()).getHandler()).removeHandler((Handler)unpublish.getSecondEntity());
        }
        return IFuture.DONE;
    }

    public IFuture<Void> publishHMTLPage(String pid, String vhost, final String html) {
        try {
            String clpid = pid.replace("[", "").replace("]", "");
            URI uri = new URI(clpid);
            Server server = (Server)this.getHttpServer(uri, null);
            System.out.println("Adding http handler to server (jetty): " + uri.getPath());
            HandlerCollection collhandler = (HandlerCollection)server.getHandler();
            ContextHandler ch = new ContextHandler(){

                public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    response.getWriter().write(html);
                    baseRequest.setHandled(true);
                }
            };
            ch.setContextPath(uri.getPath());
            collhandler.addHandler((Handler)ch);
            ch.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return IFuture.DONE;
    }

    public IFuture<Void> publishResources(String pid, String rootpath) {
        Future ret = new Future();
        try {
            String clpid = pid.replace("[", "").replace("]", "");
            URI uri = new URI(clpid);
            Server server = (Server)this.getHttpServer(uri, null);
            System.out.println("Adding http handler to server (jetty): " + uri.getPath() + " rootpath: " + rootpath);
            HandlerCollection collhandler = (HandlerCollection)server.getHandler();
            ResourceHandler rh = new ResourceHandler();
            ContextHandler ch = new ContextHandler(){

                public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    super.doHandle(target, baseRequest, request, response);
                }
            };
            ch.setBaseResource((Resource)new UniversalClasspathResource(rootpath));
            ch.setHandler((Handler)rh);
            ch.setContextPath(uri.getPath());
            collhandler.addHandler((Handler)ch);
            ch.start();
            System.out.println("Resource published at: " + uri.getPath());
            ret.setResult(null);
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }
}

