/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.base.JarAsDirectory;
import jadex.commons.SUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.jetty.util.resource.Resource;

public class UniversalClasspathResource
extends Resource {
    protected String path;
    protected URL url;
    protected File file;

    public UniversalClasspathResource(String rootpath) {
        this.path = rootpath;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        if ("/".equals(path)) {
            return this;
        }
        return new UniversalClasspathResource(this.path + path);
    }

    public URL getURL() {
        if (this.url == null) {
            this.url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.path);
            if (this.url == null && this.path.startsWith("/")) {
                this.url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.path.substring(1));
            }
            if (this.url == null && "/".equals(this.path)) {
                this.url = ((Object)((Object)this)).getClass().getClassLoader().getResource("index.html");
            }
        }
        return this.url;
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectory() {
        try {
            return this.asFile().isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long lastModified() {
        try {
            return this.asFile().lastModified();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long length() {
        try {
            return this.asFile().length();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String[] list() {
        try {
            return this.asFile().list();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.url = null;
        this.file = null;
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean exists() {
        try {
            return this.asFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File asFile() throws IOException {
        if (this.file == null && this.getURL() != null) {
            if ("file".equals(this.getURL().getProtocol())) {
                this.file = SUtil.getFile((URL)this.getURL());
            } else if ("jar".equals(this.getURL().getProtocol())) {
                String jar = this.getURL().getPath();
                String entry = null;
                if (jar.contains("!/")) {
                    entry = jar.substring(jar.indexOf("!/") + 2);
                    jar = jar.substring(0, jar.indexOf("!/"));
                }
                String path = new URL(jar).getPath();
                try (ZipFile zip = new ZipFile(path);){
                    this.file = new JarAsDirectory(path, zip.getEntry(entry));
                }
            }
        }
        return this.file;
    }

    public File getFile() throws IOException {
        return this.asFile() instanceof JarAsDirectory ? null : this.asFile();
    }

    public InputStream getInputStream() throws IOException {
        File f = this.asFile();
        if (f instanceof JarAsDirectory) {
            return new JarFile(((JarAsDirectory)f).getJarPath()).getInputStream(((JarAsDirectory)f).getZipEntry());
        }
        return new FileInputStream(this.getFile());
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }
}

